
import gurobipy as gp

# Create a new model
model = gp.Model("Optimization Problem")

# Create variables
ringo_hours = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Ringo")
george_hours = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by George")
laura_hours = model.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Laura")
dale_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="hours worked by Dale")

# Set objective function
model.setObjective(8 * ringo_hours + 4 * george_hours + 6 * laura_hours + 9 * dale_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.08 * ringo_hours + 2.81 * laura_hours >= 131, "c1")
model.addConstr(2.32 * george_hours + 2.81 * laura_hours + 2.59 * dale_hours >= 111, "c2")
model.addConstr(0.08 * ringo_hours + 2.32 * george_hours + 2.81 * laura_hours >= 111, "c3")
model.addConstr(2.32 * george_hours + 2.81 * laura_hours + 2.59 * dale_hours >= 127, "c4")
model.addConstr(0.08 * ringo_hours + 2.32 * george_hours + 2.81 * laura_hours >= 127, "c5")
model.addConstr(0.08 * ringo_hours + 2.32 * george_hours + 2.81 * laura_hours + 2.59 * dale_hours >= 127, "c6")
model.addConstr(-5 * laura_hours + 9 * dale_hours >= 0, "c7")
model.addConstr(8 * ringo_hours - 5 * laura_hours >= 0, "c8")
model.addConstr(0.08 * ringo_hours + 2.59 * dale_hours <= 262, "c9")
model.addConstr(2.81 * laura_hours + 2.59 * dale_hours <= 431, "c10")
model.addConstr(0.08 * ringo_hours + 2.32 * george_hours + 2.59 * dale_hours <= 245, "c11")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

