
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x_Ringo = m.addVar(vtype=GRB.INTEGER, name="Ringo")
x_George = m.addVar(vtype=GRB.INTEGER, name="George")
x_Laura = m.addVar(vtype=GRB.INTEGER, name="Laura")
x_Dale = m.addVar(vtype=GRB.CONTINUOUS, name="Dale")

# Objective function
m.setObjective(8*x_Ringo + 4*x_George + 6*x_Laura + 9*x_Dale, GRB.MINIMIZE)

# Constraints based on organization scores and additional constraints
m.addConstr(0.08*x_Ringo + 2.81*x_Laura >= 131)
m.addConstr(2.32*x_George + 2.81*x_Laura + 2.59*x_Dale >= 111)
m.addConstr(0.08*x_Ringo + 2.32*x_George + 2.81*x_Laura >= 111)
m.addConstr(2.32*x_George + 2.81*x_Laura + 2.59*x_Dale >= 127)
m.addConstr(0.08*x_Ringo + 2.32*x_George + 2.81*x_Laura >= 127)
m.addConstr(0.08*x_Ringo + 2.32*x_George + 2.81*x_Laura + 2.59*x_Dale >= 127)
m.addConstr(-5*x_Laura + 9*x_Dale >= 0)
m.addConstr(8*x_Ringo - 5*x_Laura >= 0)

# Upper bound constraints
m.addConstr(0.08*x_Ringo + 2.59*x_Dale <= 262)
m.addConstr(2.81*x_Laura + 2.59*x_Dale <= 431)
m.addConstr(0.08*x_Ringo + 2.32*x_George + 2.59*x_Dale <= 245)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
