
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    ringo = model.addVar(name="Ringo", vtype=gurobi.GRB.INTEGER)
    george = model.addVar(name="George", vtype=gurobi.GRB.INTEGER)
    laura = model.addVar(name="Laura", vtype=gurobi.GRB.INTEGER)
    dale = model.addVar(name="Dale")

    # Objective function
    model.setObjective(8 * ringo + 4 * george + 6 * laura + 9 * dale, gurobi.GRB.MINIMIZE)

    # Constraints
    # Organization score constraints and combined organization score constraints
    model.addConstr(0.08 * ringo + 2.81 * laura >= 131)
    model.addConstr(2.32 * george + 2.81 * laura + 2.59 * dale >= 111)
    model.addConstr(0.08 * ringo + 2.32 * george + 2.81 * laura >= 111)
    model.addConstr(2.32 * george + 2.81 * laura + 2.59 * dale >= 127)
    model.addConstr(0.08 * ringo + 2.32 * george + 2.81 * laura >= 127)
    model.addConstr(0.08 * ringo + 2.32 * george + 2.81 * laura + 2.59 * dale >= 127)

    # Linear constraints
    model.addConstr(-5 * laura + 9 * dale >= 0)
    model.addConstr(8 * ringo - 5 * laura >= 0)

    # Upper bound constraints
    model.addConstr(0.08 * ringo + 2.59 * dale <= 262)
    model.addConstr(2.81 * laura + 2.59 * dale <= 431)
    model.addConstr(0.08 * ringo + 2.32 * george + 2.59 * dale <= 245)

    # Variable bounds (explicitly stating integrality for Ringo, George, Laura)
    ringo.integrality = 1
    george.integrality = 1
    laura.integrality = 1

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Ringo: ", ringo.x)
        print("George: ", george.x)
        print("Laura: ", laura.x)
        print("Dale: ", dale.x)
    else:
        print("No optimal solution found")

optimization_problem()
