
from gurobipy import Model, GRB

# Create a new model
model = Model("WorkHoursOptimization")

# Create variables
ringo_hours = model.addVar(lb=0, name="ringo_hours")
bobby_hours = model.addVar(lb=0, name="bobby_hours")
dale_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="dale_hours")
laura_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="laura_hours")

# Set objective function
model.setObjective(9 * ringo_hours * ringo_hours + 6 * ringo_hours * bobby_hours + 5 * ringo_hours * laura_hours + 4 * bobby_hours * laura_hours + 9 * dale_hours * laura_hours + dale_hours + 8 * laura_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(1.38 * ringo_hours + 1.66 * laura_hours >= 28)
model.addConstr(6.59 * bobby_hours + 1.66 * laura_hours >= 71)
model.addConstr(18.38 * dale_hours + 1.66 * laura_hours >= 31)
model.addConstr(1.38 * ringo_hours * ringo_hours + 18.38 * dale_hours * dale_hours >= 42)
model.addConstr(1.38 * ringo_hours * ringo_hours + 18.38 * dale_hours * dale_hours + 1.66 * laura_hours * laura_hours >= 69)
model.addConstr(8.98 * bobby_hours + 13.32 * dale_hours >= 79)
model.addConstr(13.32 * dale_hours + 21.23 * laura_hours >= 45)
model.addConstr(18.15 * ringo_hours + 8.98 * bobby_hours + 21.23 * laura_hours >= 102)
model.addConstr(8.98 * bobby_hours * bobby_hours + 13.32 * dale_hours * dale_hours + 21.23 * laura_hours * laura_hours >= 102)
model.addConstr(18.15 * ringo_hours + 8.98 * bobby_hours + 21.23 * laura_hours >= 81)
model.addConstr(8.98 * bobby_hours * bobby_hours + 13.32 * dale_hours * dale_hours + 21.23 * laura_hours * laura_hours >= 81)
model.addConstr(1.38 * ringo_hours + 18.38 * dale_hours <= 298)
model.addConstr(6.59 * bobby_hours * bobby_hours + 18.38 * dale_hours * dale_hours <= 220)
model.addConstr(1.38 * ringo_hours + 1.66 * laura_hours <= 169)
model.addConstr(1.38 * ringo_hours * ringo_hours + 6.59 * bobby_hours * bobby_hours <= 144)
model.addConstr(6.59 * bobby_hours + 1.66 * laura_hours <= 93)
model.addConstr(18.38 * dale_hours + 1.66 * laura_hours <= 149)
model.addConstr(1.38 * ringo_hours + 6.59 * bobby_hours + 18.38 * dale_hours + 1.66 * laura_hours <= 149)
model.addConstr(18.15 * ringo_hours * ringo_hours + 21.23 * laura_hours * laura_hours <= 361)
model.addConstr(13.32 * dale_hours + 21.23 * laura_hours <= 316)
model.addConstr(18.15 * ringo_hours * ringo_hours + 8.98 * bobby_hours * bobby_hours <= 126)
model.addConstr(18.15 * ringo_hours + 13.32 * dale_hours + 21.23 * laura_hours <= 435)
model.addConstr(18.15 * ringo_hours * ringo_hours + 8.98 * bobby_hours * bobby_hours + 21.23 * laura_hours * laura_hours <= 297)
model.addConstr(18.15 * ringo_hours + 8.98 * bobby_hours + 13.32 * dale_hours + 21.23 * laura_hours <= 297)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Ringo Hours:', ringo_hours.x)
    print('Bobby Hours:', bobby_hours.x)
    print('Dale Hours:', dale_hours.x)
    print('Laura Hours:', laura_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

