
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
calcium = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="calcium")
vitamin_b4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b4")
iron = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")
vitamin_b7 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b7")
vitamin_b6 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b6")

# Set objective function
m.setObjective(9*calcium + 3*vitamin_b4 + 5*iron + 5*vitamin_b7 + 1*vitamin_b6, GRB.MAXIMIZE)

# Add constraints based on resource attributes
muscle_growth_index = 1*calcium + 13*vitamin_b4 + 3*iron + 8*vitamin_b7 + 11*vitamin_b6
energy_stability_index = 3*calcium + 5*vitamin_b4 + 4*iron + 10*vitamin_b7 + 14*vitamin_b6

m.addConstr(muscle_growth_index <= 471, "r0_upper_bound")
m.addConstr(energy_stability_index <= 163, "r1_upper_bound")


# Add other constraints
m.addConstr(3*iron + 8*vitamin_b7 >= 49)
m.addConstr(13*vitamin_b4 + 3*iron + 8*vitamin_b7 >= 65)
m.addConstr(1*calcium + 13*vitamin_b4 + 11*vitamin_b6 >= 65)
m.addConstr(1*calcium + 8*vitamin_b7 + 11*vitamin_b6 >= 65)
m.addConstr(13*vitamin_b4 + 3*iron + 8*vitamin_b7 >= 54)
m.addConstr(1*calcium + 13*vitamin_b4 + 11*vitamin_b6 >= 54)
m.addConstr(1*calcium + 8*vitamin_b7 + 11*vitamin_b6 >= 54)
m.addConstr(13*vitamin_b4 + 3*iron + 8*vitamin_b7 >= 84)
m.addConstr(1*calcium + 13*vitamin_b4 + 11*vitamin_b6 >= 84)
m.addConstr(1*calcium + 8*vitamin_b7 + 11*vitamin_b6 >= 84)
m.addConstr(4*iron + 14*vitamin_b6 >= 27)
m.addConstr(3*calcium + 10*vitamin_b7 >= 11)
m.addConstr(3*calcium + 4*iron >= 24)
m.addConstr(10*vitamin_b7 + 14*vitamin_b6 >= 16)
m.addConstr(5*vitamin_b4 + 14*vitamin_b6 >= 16)
m.addConstr(5*iron - 1*vitamin_b7 + 8*vitamin_b6 >= 0)
m.addConstr(calcium + vitamin_b6 <= 398/11) # Dividing both sides by 11
m.addConstr(calcium + vitamin_b7 <= 262/8)
m.addConstr(vitamin_b4 + iron <= 200/3)
m.addConstr(iron + vitamin_b6 <= 469/11)
m.addConstr(calcium + iron <= 350/3)
m.addConstr(calcium + vitamin_b4 <= 426/13)
m.addConstr(vitamin_b7 + vitamin_b6 <= 227/11)
m.addConstr(vitamin_b4 + vitamin_b6 <= 194/11)
m.addConstr(vitamin_b4 + vitamin_b7 <= 266/8)
m.addConstr(calcium + vitamin_b4 + vitamin_b6 <= 187/11)
m.addConstr(calcium + vitamin_b4 + iron + vitamin_b7 + vitamin_b6 <= 187/11)
m.addConstr(4*iron + 10*vitamin_b7 <= 111)
m.addConstr(5*vitamin_b4 + 4*iron <= 159)
m.addConstr(5*vitamin_b4 + 10*vitamin_b7 <= 84)
m.addConstr(3*calcium + 5*vitamin_b4 <= 109)
m.addConstr(5*vitamin_b4 + 14*vitamin_b6 <= 157)
m.addConstr(3*calcium + 10*vitamin_b7 <= 60)
m.addConstr(3*calcium + 4*iron <= 42)
m.addConstr(3*calcium + 5*vitamin_b4 + 4*iron <= 79)
m.addConstr(3*calcium + 10*vitamin_b7 + 14*vitamin_b6 <= 103)
m.addConstr(3*calcium + 5*vitamin_b4 + 4*iron + 10*vitamin_b7 + 14*vitamin_b6 <= 103)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
