
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="calcium", lb=0)
    x1 = model.addVar(name="vitamin_B4", lb=0)
    x2 = model.addVar(name="iron", lb=0)
    x3 = model.addVar(name="vitamin_B7", lb=0)
    x4 = model.addVar(name="vitamin_B6", lb=0)

    # Objective function
    model.setObjective(9 * x0 + 3 * x1 + 5 * x2 + 5 * x3 + x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x0 + 13 * x1 + 3 * x2 + 8 * x3 + 11 * x4 <= 471)
    model.addConstr(3 * x0 + 5 * x1 + 4 * x2 + 10 * x3 + 14 * x4 <= 163)
    model.addConstr(3 * x2 + 8 * x3 >= 49)
    model.addConstr(13 * x1 + 3 * x2 + 8 * x3 >= 65)
    model.addConstr(x0 + 13 * x1 + 11 * x4 >= 65)
    model.addConstr(x0 + 8 * x3 + 11 * x4 >= 65)
    model.addConstr(13 * x1 + 3 * x2 + 8 * x3 >= 54)
    model.addConstr(x0 + 13 * x1 + 11 * x4 >= 54)
    model.addConstr(x0 + 8 * x3 + 11 * x4 >= 54)
    model.addConstr(13 * x1 + 3 * x2 + 8 * x3 >= 84)
    model.addConstr(x0 + 13 * x1 + 11 * x4 >= 84)
    model.addConstr(x0 + 8 * x3 + 11 * x4 >= 84)
    model.addConstr(4 * x2 + 14 * x4 >= 27)
    model.addConstr(3 * x0 + 10 * x3 >= 11)
    model.addConstr(3 * x0 + 4 * x2 >= 24)
    model.addConstr(10 * x3 + 14 * x4 >= 16)
    model.addConstr(5 * x1 + 14 * x4 >= 16)
    model.addConstr(5 * x2 - x3 + 8 * x4 >= 0)
    model.addConstr(x0 + 11 * x4 <= 398)
    model.addConstr(x0 + 8 * x3 <= 262)
    model.addConstr(13 * x1 + 3 * x2 <= 200)
    model.addConstr(3 * x2 + 11 * x4 <= 469)
    model.addConstr(x0 + 3 * x2 <= 350)
    model.addConstr(x0 + 13 * x1 <= 426)
    model.addConstr(8 * x3 + 11 * x4 <= 227)
    model.addConstr(13 * x1 + 11 * x4 <= 194)
    model.addConstr(13 * x1 + 8 * x3 <= 266)
    model.addConstr(x0 + 13 * x1 + 11 * x4 <= 187)
    model.addConstr(x0 + 13 * x1 + 3 * x2 + 8 * x3 + 11 * x4 <= 187)
    model.addConstr(4 * x2 + 10 * x3 <= 111)
    model.addConstr(5 * x1 + 4 * x2 <= 159)
    model.addConstr(5 * x1 + 10 * x3 <= 84)
    model.addConstr(3 * x0 + 5 * x1 <= 109)
    model.addConstr(5 * x1 + 14 * x4 <= 157)
    model.addConstr(3 * x0 + 10 * x3 <= 60)
    model.addConstr(3 * x0 + 4 * x2 <= 42)
    model.addConstr(3 * x0 + 5 * x1 + 4 * x2 <= 79)
    model.addConstr(3 * x0 + 10 * x3 + 14 * x4 <= 103)
    model.addConstr(3 * x0 + 5 * x1 + 4 * x2 + 10 * x3 + 14 * x4 <= 103)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Calcium: ", x0.varValue)
        print("Vitamin B4: ", x1.varValue)
        print("Iron: ", x2.varValue)
        print("Vitamin B7: ", x3.varValue)
        print("Vitamin B6: ", x4.varValue)
    else:
        print("No optimal solution found.")

optimize()
