
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls of instant ramen")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="blueberry pies")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ham sandwiches")

# Set objective function
m.setObjective(8 * x0 + 7 * x1 + 8 * x2 + 4 * x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x1 + 18 * x2 >= 60, "c0")
m.addConstr(18 * x2 + 19 * x3 >= 70, "c1")
m.addConstr(8 * x0 + 18 * x2 >= 40, "c2")
m.addConstr(8 * x0 + 19 * x3 >= 52, "c3")
m.addConstr(8 * x0 + 18 * x2 + 19 * x3 >= 47, "c4")
m.addConstr(8 * x0 + 2 * x1 + 18 * x2 >= 47, "c5")
m.addConstr(8 * x0 + 18 * x2 + 19 * x3 >= 67, "c6")
m.addConstr(8 * x0 + 2 * x1 + 18 * x2 >= 67, "c7")
m.addConstr(10 * x0 + 6 * x3 >= 96, "c8")
m.addConstr(10 * x0 + 17 * x2 >= 90, "c9")
m.addConstr(21 * x1 + 6 * x3 >= 61, "c10")
m.addConstr(10 * x0 + 21 * x1 >= 121, "c11")
m.addConstr(10 * x0 + 21 * x1 + 6 * x3 >= 109, "c12")
m.addConstr(17 * x1 + 18 * x3 >= 48, "c13")
m.addConstr(3 * x2 + 18 * x3 >= 43, "c14")
m.addConstr(10 * x0 + 18 * x3 >= 55, "c15")
m.addConstr(17 * x1 + 3 * x2 >= 54, "c16")
m.addConstr(17 * x1 + 3 * x2 + 18 * x3 >= 58, "c17")

m.addConstr(8 * x0 + 19 * x3 <= 262, "c18")
m.addConstr(8 * x0 + 18 * x2 <= 190, "c19")
m.addConstr(18 * x2 + 19 * x3 <= 193, "c20")
m.addConstr(8 * x0 + 2 * x1 + 18 * x2 + 19 * x3 <= 193, "c21")
m.addConstr(10 * x0 + 17 * x2 <= 499, "c22")
m.addConstr(17 * x2 + 6 * x3 <= 233, "c23")
m.addConstr(21 * x1 + 17 * x2 <= 256, "c24")
m.addConstr(21 * x1 + 17 * x2 + 6 * x3 <= 153, "c25")
m.addConstr(10 * x0 + 21 * x1 + 17 * x2 <= 256, "c26")
m.addConstr(10 * x0 + 21 * x1 + 6 * x3 <= 369, "c27")
m.addConstr(10 * x0 + 17 * x2 + 6 * x3 <= 376, "c28")
m.addConstr(10 * x0 + 21 * x1 + 17 * x2 + 6 * x3 <= 376, "c29")
m.addConstr(17 * x1 + 18 * x3 <= 68, "c30")
m.addConstr(10 * x0 + 18 * x3 <= 166, "c31")
m.addConstr(3 * x2 + 18 * x3 <= 231, "c32")
m.addConstr(17 * x1 + 3 * x2 <= 199, "c33")
m.addConstr(10 * x0 + 17 * x1 + 3 * x2 + 18 * x3 <= 199, "c34")


# Add resource constraints based on the provided dictionary
resource_constraints = {
    'r0': {'upper_bound': 282, 'x0': 8, 'x1': 2, 'x2': 18, 'x3': 19},
    'r1': {'upper_bound': 513, 'x0': 10, 'x1': 21, 'x2': 17, 'x3': 6},
    'r2': {'upper_bound': 246, 'x0': 10, 'x1': 17, 'x2': 3, 'x3': 18}
}

for resource, data in resource_constraints.items():
    m.addConstr(
        data['x0'] * x0 + data['x1'] * x1 + data['x2'] * x2 + data['x3'] * x3 <= data['upper_bound'],
        resource
    )


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

