
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name="bowls_of_instant_ramen", lb=-gurobi.GRB.INFINITY)
x1 = m.addVar(name="blueberry_pies", lb=-gurobi.GRB.INFINITY)
x2 = m.addVar(name="kiwis", lb=-gurobi.GRB.INFINITY)
x3 = m.addVar(name="ham_sandwiches", lb=-gurobi.GRB.INFINITY)

# Objective function
m.setObjective(8*x0 + 7*x1 + 8*x2 + 4*x3, gurobi.GRB.MAXIMIZE)

# Constraints
# Healthiness rating constraints
m.addConstr(2*x1 + 18*x2 >= 60, name="healthiness_rating_blueberry_pies_kiwis")
m.addConstr(18*x2 + 19*x3 >= 70, name="healthiness_rating_kiwis_ham_sandwiches")
m.addConstr(8*x0 + 18*x2 >= 40, name="healthiness_rating_instant_ramen_kiwis")
m.addConstr(8*x0 + 19*x3 >= 52, name="healthiness_rating_instant_ramen_ham_sandwiches")
m.addConstr(8*x0 + 18*x2 + 19*x3 >= 47, name="healthiness_rating_instant_ramen_kiwis_ham_sandwiches")
m.addConstr(8*x0 + 2*x1 + 18*x2 >= 47, name="healthiness_rating_instant_ramen_blueberry_pies_kiwis")
m.addConstr(8*x0 + 18*x2 + 19*x3 >= 67, name="healthiness_rating_instant_ramen_kiwis_ham_sandwiches_eq")
m.addConstr(8*x0 + 2*x1 + 18*x2 >= 67, name="healthiness_rating_instant_ramen_blueberry_pies_kiwis_eq")
m.addConstr(8*x0 + 19*x3 <= 262, name="healthiness_rating_instant_ramen_ham_sandwiches_ub")
m.addConstr(8*x0 + 18*x2 <= 190, name="healthiness_rating_instant_ramen_kiwis_ub")
m.addConstr(18*x2 + 19*x3 <= 193, name="healthiness_rating_kiwis_ham_sandwiches_ub")
m.addConstr(8*x0 + 2*x1 + 18*x2 + 19*x3 <= 193, name="healthiness_rating_all_ub")

# Grams of fat constraints
m.addConstr(10*x0 + 6*x3 >= 96, name="fat_instant_ramen_ham_sandwiches")
m.addConstr(10*x0 + 17*x2 >= 90, name="fat_instant_ramen_kiwis")
m.addConstr(21*x1 + 6*x3 >= 61, name="fat_blueberry_pies_ham_sandwiches")
m.addConstr(10*x0 + 21*x1 >= 121, name="fat_instant_ramen_blueberry_pies")
m.addConstr(10*x0 + 21*x1 + 6*x3 >= 109, name="fat_all")
m.addConstr(10*x0 + 17*x2 <= 499, name="fat_instant_ramen_kiwis_ub")
m.addConstr(17*x2 + 6*x3 <= 233, name="fat_kiwis_ham_sandwiches_ub")
m.addConstr(21*x1 + 17*x2 <= 256, name="fat_blueberry_pies_kiwis_ub")
m.addConstr(21*x1 + 17*x2 + 6*x3 <= 153, name="fat_blueberry_pies_kiwis_ham_sandwiches_ub")
m.addConstr(10*x0 + 21*x1 + 17*x2 <= 256, name="fat_instant_ramen_blueberry_pies_kiwis_ub")
m.addConstr(10*x0 + 21*x1 + 6*x3 <= 369, name="fat_instant_ramen_blueberry_pies_ham_sandwiches_ub")
m.addConstr(10*x0 + 17*x2 + 6*x3 <= 376, name="fat_instant_ramen_kiwis_ham_sandwiches_ub")
m.addConstr(10*x0 + 21*x1 + 17*x2 + 6*x3 <= 376, name="fat_all_ub")

# Tastiness rating constraints
m.addConstr(17*x1 + 18*x3 >= 48, name="tastiness_blueberry_pies_ham_sandwiches")
m.addConstr(3*x2 + 18*x3 >= 43, name="tastiness_kiwis_ham_sandwiches")
m.addConstr(10*x0 + 18*x3 >= 55, name="tastiness_instant_ramen_ham_sandwiches")
m.addConstr(17*x1 + 3*x2 >= 54, name="tastiness_blueberry_pies_kiwis")
m.addConstr(17*x1 + 3*x2 + 18*x3 >= 58, name="tastiness_all")
m.addConstr(17*x1 + 18*x3 <= 68, name="tastiness_blueberry_pies_ham_sandwiches_ub")
m.addConstr(10*x0 + 18*x3 <= 166, name="tastiness_instant_ramen_ham_sandwiches_ub")
m.addConstr(3*x2 + 18*x3 <= 231, name="tastiness_kiwis_ham_sandwiches_ub")
m.addConstr(17*x1 + 3*x2 <= 199, name="tastiness_blueberry_pies_kiwis_ub")
m.addConstr(10*x0 + 17*x1 + 3*x2 + 18*x3 <= 199, name="tastiness_all_ub")

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bowls_of_instant_ramen: ", x0.varValue)
    print("blueberry_pies: ", x1.varValue)
    print("kiwis: ", x2.varValue)
    print("ham_sandwiches: ", x3.varValue)
else:
    print("No solution found")
