
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
steaks = m.addVar(vtype=GRB.INTEGER, name="steaks")
strawberries = m.addVar(vtype=GRB.INTEGER, name="strawberries")
apples = m.addVar(vtype=GRB.CONTINUOUS, name="apples")
corn_cobs = m.addVar(vtype=GRB.INTEGER, name="corn_cobs")
blueberry_pies = m.addVar(vtype=GRB.CONTINUOUS, name="blueberry_pies")
tomatoes = m.addVar(vtype=GRB.CONTINUOUS, name="tomatoes")

# Set objective function
m.setObjective(2.34 * steaks * strawberries + 8.72 * steaks * corn_cobs + 4.51 * steaks * tomatoes + 9.42 * strawberries**2 + 4.66 * strawberries * tomatoes + 8.85 * apples**2 + 8.08 * apples * corn_cobs + 6.46 * apples * blueberry_pies + 2.15 * apples * tomatoes + 5.37 * corn_cobs**2 + 4.39 * corn_cobs * blueberry_pies + 3.46 * blueberry_pies**2 + 4.48 * blueberry_pies * tomatoes + 7.15 * tomatoes**2 + 4.83 * steaks + 4.84 * strawberries + 7.08 * apples + 8.37 * corn_cobs, GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * blueberry_pies**2 + 2 * tomatoes**2 >= 135)
m.addConstr(7 * apples + 19 * corn_cobs >= 133)
m.addConstr(14 * steaks + 15 * strawberries >= 101)
m.addConstr(15 * strawberries + 7 * apples >= 66)
m.addConstr(15 * strawberries + 2 * tomatoes >= 140)
m.addConstr(14 * steaks + 15 * strawberries + 7 * apples + 19 * corn_cobs + 7 * blueberry_pies + 2 * tomatoes >= 140)
m.addConstr(10 * corn_cobs + 4 * tomatoes >= 56)
m.addConstr(10 * corn_cobs + 11 * blueberry_pies >= 77)
m.addConstr(12 * steaks + 7 * apples >= 58)
m.addConstr(20 * strawberries + 7 * apples >= 94)
m.addConstr(7 * apples + 11 * blueberry_pies >= 76)
m.addConstr(12 * steaks + 11 * blueberry_pies >= 61)
m.addConstr(20 * strawberries**2 + 10 * corn_cobs**2 >= 66)
m.addConstr(12 * steaks + 20 * strawberries >= 55)
m.addConstr(11 * blueberry_pies**2 + 4 * tomatoes**2 >= 98)
m.addConstr(7 * apples**2 + 10 * corn_cobs**2 >= 81)
m.addConstr(7 * apples + 4 * tomatoes >= 38)
m.addConstr(12 * steaks**2 + 7 * apples**2 + 4 * tomatoes**2 >= 66)
m.addConstr(20 * strawberries + 10 * corn_cobs + 4 * tomatoes >= 66)
m.addConstr(12 * steaks + 7 * apples + 4 * tomatoes >= 87)
m.addConstr(20 * strawberries**2 + 10 * corn_cobs**2 + 4 * tomatoes**2 >= 87)
m.addConstr(12 * steaks + 20 * strawberries + 7 * apples + 10 * corn_cobs + 11 * blueberry_pies + 4 * tomatoes >= 87)
m.addConstr(steaks**2 - 4 * blueberry_pies**2 >= 0)
m.addConstr(15 * strawberries + 19 * corn_cobs <= 770)
m.addConstr(7 * blueberry_pies**2 + 2 * tomatoes**2 <= 760)
m.addConstr(15 * strawberries + 7 * blueberry_pies <= 238)
m.addConstr(19 * corn_cobs + 7 * blueberry_pies <= 183)
m.addConstr(14 * steaks**2 + 19 * corn_cobs**2 <= 851)
m.addConstr(7 * apples**2 + 19 * corn_cobs**2 <= 611)
m.addConstr(15 * strawberries + 7 * apples + 2 * tomatoes <= 168)
m.addConstr(14 * steaks + 15 * strawberries + 7 * blueberry_pies <= 784)
m.addConstr(7 * apples + 19 * corn_cobs + 2 * tomatoes <= 744)
m.addConstr(19 * corn_cobs + 7 * blueberry_pies + 2 * tomatoes <= 346)
m.addConstr(14 * steaks + 15 * strawberries + 19 * corn_cobs <= 462)
m.addConstr(14 * steaks + 15 * strawberries + 7 * apples <= 360)
m.addConstr(14 * steaks**2 + 7 * apples**2 + 7 * blueberry_pies**2 <= 208)
m.addConstr(15 * strawberries + 7 * apples + 19 * corn_cobs <= 406)
m.addConstr(20 * strawberries**2 + 4 * tomatoes**2 <= 494)
m.addConstr(7 * apples**2 + 4 * tomatoes**2 <= 240)
m.addConstr(10 * corn_cobs**2 + 4 * tomatoes**2 <= 317)
m.addConstr(7 * apples + 11 * blueberry_pies <= 162)
m.addConstr(11 * blueberry_pies + 4 * tomatoes <= 108)
m.addConstr(12 * steaks**2 + 4 * tomatoes**2 <= 616)
m.addConstr(12 * steaks + 20 * strawberries <= 195)
m.addConstr(12 * steaks**2 + 7 * apples**2 <= 149)
m.addConstr(7 * apples**2 + 10 * corn_cobs**2 <= 380)
m.addConstr(20 * strawberries + 11 * blueberry_pies <= 210)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
