
from gurobipy import Model, GRB

# Create a new model
m = Model("minimize_cost")

# Create variables
bill_hours = m.addVar(vtype=GRB.INTEGER, name="bill_hours")
jean_hours = m.addVar(vtype=GRB.INTEGER, name="jean_hours")
paul_hours = m.addVar(vtype=GRB.INTEGER, name="paul_hours")

# Set objective function
m.setObjective(2 * bill_hours + 9 * jean_hours + 4 * paul_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * jean_hours + 4 * paul_hours >= 13, "c1")
m.addConstr(8 * bill_hours + 4 * paul_hours >= 11, "c2")
m.addConstr(8 * bill_hours + 7 * jean_hours + 4 * paul_hours >= 11, "c3")
m.addConstr(jean_hours + 3 * paul_hours >= 6, "c4")
m.addConstr(bill_hours + 3 * paul_hours >= 12, "c5")
m.addConstr(bill_hours + jean_hours + 3 * paul_hours >= 12, "c6")
m.addConstr(-3 * bill_hours + 8 * jean_hours >= 0, "c7")
m.addConstr(-2 * bill_hours + 6 * paul_hours >= 0, "c8")
m.addConstr(7 * jean_hours + 4 * paul_hours <= 25, "c9")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Bill Hours: %g' % bill_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
    print('Paul Hours: %g' % paul_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

