
from gurobipy import *

# Create a new model
m = Model("Work_Hours_Optimization")

# Define variables
hours_Bill = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")
hours_Jean = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")
hours_Paul = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")

# Objective function
m.setObjective(2*hours_Bill + 9*hours_Jean + 4*hours_Paul, GRB.MINIMIZE)

# Constraints
# Dollar cost per hour constraints
m.addConstr(7*hours_Jean + 4*hours_Paul >= 13, "dollar_cost_Jean_Paul")
m.addConstr(8*hours_Bill + 4*hours_Paul >= 11, "dollar_cost_Bill_Paul")
m.addConstr(8*hours_Bill + 7*hours_Jean + 4*hours_Paul >= 11, "dollar_cost_all")

# Productivity rating constraints
m.addConstr(hours_Jean + 3*hours_Paul >= 6, "productivity_Jean_Paul")
m.addConstr(hours_Bill + 3*hours_Paul >= 12, "productivity_Bill_Paul")
m.addConstr(hours_Bill + hours_Jean + 3*hours_Paul >= 12, "productivity_all")

# Additional constraints
m.addConstr(-3*hours_Bill + 8*hours_Jean >= 0, "constraint_Bill_Jean")
m.addConstr(-2*hours_Bill + 6*hours_Paul >= 0, "constraint_Bill_Paul")

# Upper bound constraint for dollar cost per hour from Jean and Paul
m.addConstr(7*hours_Jean + 4*hours_Paul <= 25, "upper_bound_dollar_cost_Jean_Paul")

# Optimize the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
