
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
bill_hours = m.addVar(name="bill_hours", vtype=gp.GRB.INTEGER)
jean_hours = m.addVar(name="jean_hours", vtype=gp.GRB.INTEGER)
paul_hours = m.addVar(name="paul_hours", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(2 * bill_hours + 9 * jean_hours + 4 * paul_hours, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(7 * jean_hours + 4 * paul_hours >= 13)
m.addConstr(8 * bill_hours + 4 * paul_hours >= 11)
m.addConstr(8 * bill_hours + 7 * jean_hours + 4 * paul_hours >= 11)
m.addConstr(1 * jean_hours + 3 * paul_hours >= 6)
m.addConstr(1 * bill_hours + 3 * paul_hours >= 12)
m.addConstr(1 * bill_hours + 1 * jean_hours + 3 * paul_hours >= 12)
m.addConstr(-3 * bill_hours + 8 * jean_hours >= 0)
m.addConstr(-2 * bill_hours + 6 * paul_hours >= 0)
m.addConstr(7 * jean_hours + 4 * paul_hours <= 25)

# Non-negativity constraints
m.addConstr(bill_hours >= 0)
m.addConstr(jean_hours >= 0)
m.addConstr(paul_hours >= 0)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bill's hours: {bill_hours.varValue}")
    print(f"Jean's hours: {jean_hours.varValue}")
    print(f"Paul's hours: {paul_hours.varValue}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found.")
