
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
yellow_highlighters = model.addVar(vtype=GRB.INTEGER, name="yellow_highlighters")
blue_pens = model.addVar(vtype=GRB.INTEGER, name="blue_pens")
mechanical_pencils = model.addVar(vtype=GRB.INTEGER, name="mechanical_pencils")
wooden_pencils = model.addVar(vtype=GRB.INTEGER, name="wooden_pencils")

# Set objective function
model.setObjective(4 * yellow_highlighters + 2 * blue_pens + 6 * mechanical_pencils + 3 * wooden_pencils, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * yellow_highlighters + 2 * blue_pens >= 9, "c1")
model.addConstr(6 * yellow_highlighters + 9 * wooden_pencils >= 11, "c2")
model.addConstr(6 * yellow_highlighters + 2 * blue_pens + 4 * mechanical_pencils + 9 * wooden_pencils >= 11, "c3")
model.addConstr(2 * yellow_highlighters + 8 * wooden_pencils >= 26, "c4")
model.addConstr(3 * blue_pens + 4 * mechanical_pencils >= 11, "c5")
model.addConstr(2 * yellow_highlighters + 3 * blue_pens + 8 * wooden_pencils >= 17, "c6")
model.addConstr(3 * blue_pens + 4 * mechanical_pencils + 8 * wooden_pencils >= 17, "c7")
model.addConstr(2 * yellow_highlighters + 4 * mechanical_pencils + 8 * wooden_pencils >= 17, "c8")
model.addConstr(2 * yellow_highlighters + 3 * blue_pens + 8 * wooden_pencils >= 13, "c9")
model.addConstr(3 * blue_pens + 4 * mechanical_pencils + 8 * wooden_pencils >= 13, "c10")
model.addConstr(2 * yellow_highlighters + 4 * mechanical_pencils + 8 * wooden_pencils >= 13, "c11")
model.addConstr(2 * yellow_highlighters + 3 * blue_pens + 8 * wooden_pencils >= 17, "c12")
model.addConstr(3 * blue_pens + 4 * mechanical_pencils + 8 * wooden_pencils >= 17, "c13")
model.addConstr(2 * yellow_highlighters + 4 * mechanical_pencils + 8 * wooden_pencils >= 17, "c14")
model.addConstr(2 * yellow_highlighters + 3 * blue_pens + 4 * mechanical_pencils + 8 * wooden_pencils >= 17, "c15")
model.addConstr(3 * mechanical_pencils + 3 * wooden_pencils >= 10, "c16")
model.addConstr(2 * blue_pens + 3 * mechanical_pencils >= 12, "c17")
model.addConstr(2 * yellow_highlighters + 2 * blue_pens >= 22, "c18")
model.addConstr(2 * yellow_highlighters + 3 * mechanical_pencils >= 13, "c19")
model.addConstr(2 * yellow_highlighters + 2 * blue_pens + 3 * mechanical_pencils + 3 * wooden_pencils >= 13, "c20")
model.addConstr(5 * blue_pens + 2 * mechanical_pencils >= 16, "c21")
model.addConstr(11 * yellow_highlighters + 5 * wooden_pencils >= 11, "c22")
model.addConstr(5 * blue_pens + 5 * wooden_pencils >= 13, "c23")
model.addConstr(11 * yellow_highlighters + 2 * mechanical_pencils >= 15, "c24")
model.addConstr(11 * yellow_highlighters + 5 * blue_pens + 2 * mechanical_pencils + 5 * wooden_pencils >= 15, "c25")
model.addConstr(1 * blue_pens + 8 * mechanical_pencils >= 8, "c26")
model.addConstr(3 * yellow_highlighters + 1 * blue_pens >= 16, "c27")
model.addConstr(3 * yellow_highlighters + 8 * mechanical_pencils >= 15, "c28")
model.addConstr(1 * blue_pens + 1 * wooden_pencils >= 20, "c29")
model.addConstr(3 * yellow_highlighters + 1 * blue_pens + 8 * mechanical_pencils + 1 * wooden_pencils >= 20, "c30")
model.addConstr(-7 * yellow_highlighters + 4 * wooden_pencils >= 0, "c31")

#Resource Constraints
model.addConstr(6 * yellow_highlighters + 2 * blue_pens + 4 * mechanical_pencils + 9 * wooden_pencils <= 101, "r0")
model.addConstr(2 * yellow_highlighters + 3 * blue_pens + 4 * mechanical_pencils + 8 * wooden_pencils <= 104, "r1")
model.addConstr(2 * yellow_highlighters + 2 * blue_pens + 3 * mechanical_pencils + 3 * wooden_pencils <= 94, "r2")
model.addConstr(11 * yellow_highlighters + 5 * blue_pens + 2 * mechanical_pencils + 5 * wooden_pencils <= 85, "r3")
model.addConstr(3 * yellow_highlighters + 1 * blue_pens + 8 * mechanical_pencils + 1 * wooden_pencils <= 87, "r4")


#Additional Constraints
model.addConstr(2 * blue_pens + 3 * mechanical_pencils <= 63, "c32")
model.addConstr(2 * yellow_highlighters + 3 * mechanical_pencils <= 91, "c33")
model.addConstr(2 * yellow_highlighters + 3 * wooden_pencils <= 78, "c34")
model.addConstr(2 * yellow_highlighters + 3 * mechanical_pencils + 3 * wooden_pencils <= 81, "c35")
model.addConstr(2 * yellow_highlighters + 2 * blue_pens + 3 * mechanical_pencils <= 89, "c36")
model.addConstr(2 * yellow_highlighters + 2 * blue_pens + 3 * wooden_pencils <= 79, "c37")
model.addConstr(2 * mechanical_pencils + 5 * wooden_pencils <= 85, "c38")
model.addConstr(5 * blue_pens + 5 * wooden_pencils <= 62, "c39")
model.addConstr(5 * blue_pens + 2 * mechanical_pencils <= 64, "c40")
model.addConstr(11 * yellow_highlighters + 5 * wooden_pencils <= 82, "c41")
model.addConstr(11 * yellow_highlighters + 5 * blue_pens + 2 * mechanical_pencils <= 52, "c42")
model.addConstr(11 * yellow_highlighters + 5 * blue_pens + 5 * wooden_pencils <= 73, "c43")
model.addConstr(1 * blue_pens + 8 * mechanical_pencils <= 72, "c44")
model.addConstr(3 * yellow_highlighters + 1 * wooden_pencils <= 45, "c45")
model.addConstr(3 * yellow_highlighters + 8 * mechanical_pencils <= 61, "c46")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('yellow_highlighters:', yellow_highlighters.x)
    print('blue_pens:', blue_pens.x)
    print('mechanical_pencils:', mechanical_pencils.x)
    print('wooden_pencils:', wooden_pencils.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

