
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
y = m.addVar(name="yellow_highlighters", vtype=gp.GRB.INTEGER)
b = m.addVar(name="blue_pens", vtype=gp.GRB.INTEGER)
m_var = m.addVar(name="mechanical_pencils", vtype=gp.GRB.INTEGER)
w = m.addVar(name="wooden_pencils", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(4 * y + 2 * b + 6 * m_var + 3 * w, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * y + 2 * b >= 9)
m.addConstr(6 * y + 9 * w >= 11)
m.addConstr(6 * y + 2 * b + 4 * m_var + 9 * w >= 11)
m.addConstr(2 * y + 8 * w >= 26)
m.addConstr(3 * b + 4 * m_var >= 11)
m.addConstr(2 * y + 3 * b + 8 * w >= 17)
m.addConstr(3 * b + 4 * m_var + 8 * w >= 17)
m.addConstr(2 * y + 4 * m_var + 8 * w >= 17)
m.addConstr(2 * y + 3 * b + 8 * w >= 13)
m.addConstr(3 * b + 4 * m_var + 8 * w >= 13)
m.addConstr(2 * y + 4 * m_var + 8 * w >= 13)
m.addConstr(2 * y + 3 * b + 8 * w >= 17)
m.addConstr(3 * b + 4 * m_var + 8 * w >= 17)
m.addConstr(2 * y + 4 * m_var + 8 * w >= 17)
m.addConstr(2 * y + 3 * b + 4 * m_var + 8 * w >= 17)
m.addConstr(2 * m_var + 3 * w >= 10)
m.addConstr(2 * b + 3 * m_var >= 12)
m.addConstr(2 * y + 2 * b >= 22)
m.addConstr(2 * y + 3 * m_var >= 13)
m.addConstr(2 * y + 2 * b + 3 * m_var + 3 * w >= 13)
m.addConstr(5 * b + 2 * m_var >= 16)
m.addConstr(11 * y + 5 * w >= 11)
m.addConstr(5 * b + 5 * w >= 13)
m.addConstr(11 * y + 2 * m_var >= 15)
m.addConstr(11 * y + 5 * b + 2 * m_var + 5 * w >= 15)
m.addConstr(b + 8 * m_var >= 8)
m.addConstr(3 * y + b >= 16)
m.addConstr(3 * y + 8 * m_var >= 15)
m.addConstr(b + w >= 20)
m.addConstr(3 * y + b + 8 * m_var + w >= 20)
m.addConstr(-7 * y + 4 * w >= 0)
m.addConstr(2 * b + 3 * m_var <= 63)
m.addConstr(2 * y + 3 * m_var <= 91)
m.addConstr(2 * y + 3 * w <= 78)
m.addConstr(2 * y + 3 * m_var + 3 * w <= 81)
m.addConstr(2 * y + 2 * b + 3 * m_var <= 89)
m.addConstr(2 * y + 2 * b + 3 * w <= 79)
m.addConstr(2 * m_var + 5 * w <= 85)
m.addConstr(5 * b + 5 * w <= 62)
m.addConstr(5 * b + 2 * m_var <= 64)
m.addConstr(11 * y + 5 * w <= 82)
m.addConstr(11 * y + 5 * b + 2 * m_var <= 52)
m.addConstr(11 * y + 5 * b + 5 * w <= 73)
m.addConstr(b + 8 * m_var <= 72)
m.addConstr(3 * y + w <= 45)
m.addConstr(3 * y + 8 * m_var <= 61)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Yellow highlighters: ", y.varValue)
    print("Blue pens: ", b.varValue)
    print("Mechanical pencils: ", m_var.varValue)
    print("Wooden pencils: ", w.varValue)
else:
    print("The model is infeasible")
