
from gurobipy import Model, GRB

# Create a new model
m = Model("Deployment Optimization")

# Create variables
recon_troops = m.addVar(vtype=GRB.INTEGER, name="recon_troops")
mil_intel_co = m.addVar(vtype=GRB.INTEGER, name="mil_intel_co")

# Set objective function
m.setObjective(1.57 * recon_troops + 9.68 * mil_intel_co, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * recon_troops + 2 * mil_intel_co >= 48, "min_deployment_weight")
m.addConstr(-8 * recon_troops + 9 * mil_intel_co >= 0, "troop_ratio")
m.addConstr(12 * recon_troops + 2 * mil_intel_co <= 138, "max_deployment_weight") 

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Reconnaissance Troops: {recon_troops.x}")
    print(f"  Military Intelligence Companies: {mil_intel_co.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

