
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables
x0 = model.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x1 = model.addVar(vtype=GRB.INTEGER, name="military_intelligence_companies")

# Set the objective function
model.setObjective(1.57*x0 + 9.68*x1, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*x0 + 2*x1 >= 48, "total_weight_min")
model.addConstr(-8*x0 + 9*x1 >= 0, "mixed_constraint")
model.addConstr(12*x0 + 2*x1 <= 138, "total_weight_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Reconnaissance Troops: {x0.x}")
    print(f"Military Intelligence Companies: {x1.x}")
    print(f"Objective Function Value: {model.objVal}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")

