
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    reconnaissance_troops = model.addVar(name="reconnaissance_troops", vtype=gurobi.GRB.INTEGER)
    military_intelligence_companies = model.addVar(name="military_intelligence_companies", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1.57 * reconnaissance_troops + 9.68 * military_intelligence_companies, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Deployment weight coefficients
    r0_coefficient_reconnaissance = 12
    r0_coefficient_military_intelligence = 2

    # Minimum total deployment weight constraint
    model.addConstr(r0_coefficient_reconnaissance * reconnaissance_troops + r0_coefficient_military_intelligence * military_intelligence_companies >= 48, name="min_deployment_weight")

    # Linear constraint
    model.addConstr(-8 * reconnaissance_troops + 9 * military_intelligence_companies >= 0, name="linear_constraint")

    # Maximum total deployment weight constraint
    model.addConstr(r0_coefficient_reconnaissance * reconnaissance_troops + r0_coefficient_military_intelligence * military_intelligence_companies <= 138, name="max_deployment_weight")

    # Bounds for variables (explicitly setting bounds based on problem description)
    model.addConstr(reconnaissance_troops >= 0, name="reconnaissance_troops_non_negative")
    model.addConstr(military_intelligence_companies >= 0, name="military_intelligence_companies_non_negative")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Reconnaissance Troops: {reconnaissance_troops.varValue}")
        print(f"Military Intelligence Companies: {military_intelligence_companies.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_optimization_problem()
