
from gurobipy import Model, GRB

# Create a new model
model = Model("Employee_Hours")

# Create variables
jean_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Jean_Hours")
ringo_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Ringo_Hours")

# Set objective function
model.setObjective(3.51 * jean_hours + 7.43 * ringo_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * jean_hours + 21 * ringo_hours >= 44, "Organization_Score_Min")
model.addConstr(13 * jean_hours + 10 * ringo_hours >= 46, "Likelihood_to_Quit_Min")
model.addConstr(9 * jean_hours + 8 * ringo_hours >= 16, "Work_Quality_Min")
model.addConstr(3 * jean_hours - 4 * ringo_hours >= 0, "Custom_Constraint")
model.addConstr(6 * jean_hours + 21 * ringo_hours <= 113, "Organization_Score_Max")
model.addConstr(13 * jean_hours + 10 * ringo_hours <= 126, "Likelihood_to_Quit_Max")
model.addConstr(9 * jean_hours + 8 * ringo_hours <= 65, "Work_Quality_Max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('Jean Hours:', jean_hours.x)
    print('Ringo Hours:', ringo_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status:', model.status)

