
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
hours_worked_by_Jean = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
hours_worked_by_Ringo = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")

# Set the objective function
m.setObjective(3.51 * hours_worked_by_Jean + 7.43 * hours_worked_by_Ringo, GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * hours_worked_by_Jean + 21 * hours_worked_by_Ringo >= 44, name="min_organization_score")
m.addConstr(6 * hours_worked_by_Jean + 21 * hours_worked_by_Ringo <= 113, name="max_organization_score")

m.addConstr(13 * hours_worked_by_Jean + 10 * hours_worked_by_Ringo >= 46, name="min_likelihood_to_quit")
m.addConstr(13 * hours_worked_by_Jean + 10 * hours_worked_by_Ringo <= 126, name="max_likelihood_to_quit")

m.addConstr(9 * hours_worked_by_Jean + 8 * hours_worked_by_Ringo >= 16, name="min_work_quality_rating")
m.addConstr(9 * hours_worked_by_Jean + 8 * hours_worked_by_Ringo <= 65, name="max_work_quality_rating")

m.addConstr(3 * hours_worked_by_Jean - 4 * hours_worked_by_Ringo >= 0, name="additional_linear_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Jean: {hours_worked_by_Jean.x}")
    print(f"Hours worked by Ringo: {hours_worked_by_Ringo.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
