
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    jean_hours = model.addVar(name="jean_hours", lb=0)  # Assuming hours cannot be negative
    ringo_hours = model.addVar(name="ringo_hours", lb=0)  # Assuming hours cannot be negative

    # Objective function
    model.setObjective(3.51 * jean_hours + 7.43 * ringo_hours, gurobi.GRB.MINIMIZE)

    # Attribute coefficients
    r0_x0, r0_x1 = 6, 21
    r1_x0, r1_x1 = 13, 10
    r2_x0, r2_x1 = 9, 8

    # Constraints
    model.addConstr(r0_x0 * jean_hours + r0_x1 * ringo_hours >= 44, name="org_score_min")
    model.addConstr(r0_x0 * jean_hours + r0_x1 * ringo_hours <= 113, name="org_score_max")

    model.addConstr(r1_x0 * jean_hours + r1_x1 * ringo_hours >= 46, name="quit_index_min")
    model.addConstr(r1_x0 * jean_hours + r1_x1 * ringo_hours <= 126, name="quit_index_max")

    model.addConstr(r2_x0 * jean_hours + r2_x1 * ringo_hours >= 16, name="work_quality_min")
    model.addConstr(r2_x0 * jean_hours + r2_x1 * ringo_hours <= 65, name="work_quality_max")

    model.addConstr(3 * jean_hours - 4 * ringo_hours >= 0, name="linear_constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Jean's hours: {jean_hours.varValue}")
        print(f"Ringo's hours: {ringo_hours.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
