
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    D = model.addVar(name="Dale", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # Integer
    H = model.addVar(name="Hank", lb=0, ub=None)  # Continuous
    G = model.addVar(name="George", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # Integer
    B = model.addVar(name="Bobby", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # Integer
    L = model.addVar(name="Laura", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # Integer

    # Objective function
    model.setObjective(3.39 * D**2 + 4.91 * D * H + 6.53 * D * G + 7.29 * D * B + 8.13 * D * L +
                       7.6 * H**2 + 9.61 * H * G + 6.55 * H * L + 9.68 * G**2 + 4.11 * G * B + 9.08 * G * L +
                       9.4 * L**2 + 2.71 * D + 7.89 * G + 9.21 * B + 5.64 * L, gurobi.GRB.MINIMIZE)

    # Constraints
    # Individual computer competence ratings
    model.addConstr(D <= 153, name="D_computer_rating")
    model.addConstr(6 * H <= 153, name="H_computer_rating")
    model.addConstr(12 * G <= 153, name="G_computer_rating")
    model.addConstr(B <= 153, name="B_computer_rating")
    model.addConstr(L <= 153, name="L_computer_rating")

    # Individual dollar cost per hour
    model.addConstr(12 * D <= 243, name="D_dollar_cost")
    model.addConstr(10 * H <= 243, name="H_dollar_cost")
    model.addConstr(2 * G <= 243, name="G_dollar_cost")
    model.addConstr(12 * B <= 243, name="B_dollar_cost")
    model.addConstr(7 * L <= 243, name="L_dollar_cost")

    # Combined computer competence ratings
    model.addConstr(B + L >= 18, name="B_L_computer_rating")
    model.addConstr(D**2 + G**2 >= 14, name="D_G_computer_rating")
    model.addConstr(H + L >= 23, name="H_L_computer_rating")
    model.addConstr(H + B >= 24, name="H_B_computer_rating")
    model.addConstr(D + B >= 18, name="D_B_computer_rating")
    model.addConstr(D + H + G + B + L >= 18, name="all_computer_rating")

    # Combined dollar costs
    model.addConstr(D**2 + H**2 >= 39, name="D_H_dollar_cost")
    model.addConstr(D * G >= 45, name="D_G_dollar_cost")
    model.addConstr(D + B >= 30, name="D_B_dollar_cost")
    model.addConstr(D**2 + H**2 + G**2 >= 37, name="D_H_G_dollar_cost")
    model.addConstr(D * H * B >= 37, name="D_H_B_dollar_cost")  # Note: This might need adjustment as it's nonlinear
    model.addConstr(H * B * L >= 37, name="H_B_L_dollar_cost")
    model.addConstr(D**2 + H**2 + G**2 >= 33, name="D_H_G_dollar_cost_33")
    model.addConstr(D + H + B >= 33, name="D_H_B_dollar_cost_33")
    model.addConstr(H + B + L >= 33, name="H_B_L_dollar_cost_33")

    # More combined dollar costs
    model.addConstr(D * H * G >= 41, name="D_H_G_dollar_cost_41")
    model.addConstr(D * H * B >= 41, name="D_H_B_dollar_cost_41")
    model.addConstr(H * B * L >= 41, name="H_B_L_dollar_cost_41")
    model.addConstr(D * H * G * B * L >= 41, name="all_dollar_cost")

    # Linear constraints
    model.addConstr(4 * D - 7 * G >= 0, name="linear_constraint_1")
    model.addConstr(-9 * G + 8 * B >= 0, name="linear_constraint_2")

    # Upper bounds for computer competence ratings
    model.addConstr(B + L <= 107, name="B_L_computer_rating_max")
    model.addConstr(D**2 + H**2 + G**2 <= 135, name="D_H_G_computer_rating_max")
    model.addConstr(D**2 + H**2 + L**2 <= 83, name="D_H_L_computer_rating_max")
    model.addConstr(G + B + L <= 52, name="G_B_L_computer_rating_max")
    model.addConstr(D + B + L <= 129, name="D_B_L_computer_rating_max")
    model.addConstr(D + G + B <= 120, name="D_G_B_computer_rating_max")
    model.addConstr(H + G + L <= 113, name="H_G_L_computer_rating_max")
    model.addConstr(H + G + B <= 129, name="H_G_B_computer_rating_max")
    model.addConstr(D + G + L <= 78, name="D_G_L_computer_rating_max")
    model.addConstr(H + B + L <= 94, name="H_B_L_computer_rating_max")

    # Upper bounds for dollar costs
    model.addConstr(D**2 + H**2 + L**2 <= 106, name="D_H_L_dollar_cost_max")
    model.addConstr(D + H + G <= 189, name="D_H_G_dollar_cost_max")
    model.addConstr(D * G * B <= 93, name="D_G_B_dollar_cost_max")  # Note: Nonlinear
    model.addConstr(H**2 + G**2 + B**2 <= 148, name="H_G_B_dollar_cost_max")
    model.addConstr(H + B + L <= 234, name="H_B_L_dollar_cost_max")
    model.addConstr(D**2 + G**2 + L**2 <= 202, name="D_G_L_dollar_cost_max")
    model.addConstr(G + B + L <= 135, name="G_B_L_dollar_cost_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Dale: ", D.varValue)
        print("Hank: ", H.varValue)
        print("George: ", G.varValue)
        print("Bobby: ", B.varValue)
        print("Laura: ", L.varValue)
    else:
        print("No solution found")

optimize_problem()
