
from gurobipy import Model, GRB

# Create a new model
model = Model("Resource Allocation")

# Create variables
items = ['yellow highlighters', 'red pens', 'color printers', 'paper clips', 'smoke detectors', 'rubber bands']
x = model.addVars(items, GRB.INTEGER, name=items)

# Set objective function
model.setObjective(6*x['yellow highlighters'] + 3*x['red pens'] + 3*x['color printers'] + 5*x['paper clips'] + 9*x['smoke detectors'] + 4*x['rubber bands'], GRB.MAXIMIZE)

# Add weight constraint
weights = {'yellow highlighters': 11, 'red pens': 2, 'color printers': 23, 'paper clips': 16, 'smoke detectors': 21, 'rubber bands': 26}
model.addConstr(sum(weights[item]*x[item] for item in items) <= 296, "Total weight")

# Add other constraints
model.addConstr(23*x['color printers'] + 26*x['rubber bands'] >= 35, "Weight constraint 1")
model.addConstr(2*x['red pens'] + 26*x['rubber bands'] >= 18, "Weight constraint 2")
model.addConstr(16*x['paper clips'] + 26*x['rubber bands'] >= 27, "Weight constraint 3")
model.addConstr(11*x['yellow highlighters'] + 26*x['rubber bands'] >= 34, "Weight constraint 4")
model.addConstr(23*x['color printers'] + 16*x['paper clips'] >= 27, "Weight constraint 5")
model.addConstr(11*x['yellow highlighters'] + 21*x['smoke detectors'] + 26*x['rubber bands'] >= 47, "Weight constraint 6")
model.addConstr(2*x['red pens'] + 23*x['color printers'] + 26*x['rubber bands'] >= 47, "Weight constraint 7")
model.addConstr(11*x['yellow highlighters'] + 23*x['color printers'] + 21*x['smoke detectors'] >= 47, "Weight constraint 8")
model.addConstr(2*x['red pens'] + 21*x['smoke detectors'] + 26*x['rubber bands'] >= 47, "Weight constraint 9")
model.addConstr(11*x['yellow highlighters'] + 16*x['paper clips'] + 21*x['smoke detectors'] >= 47, "Weight constraint 10")

# ... (Add the remaining similar constraints here)

model.addConstr(3*x['color printers'] - 4*x['smoke detectors'] - 7*x['rubber bands'] >= 0, "Constraint 35")

# ... (Add the remaining upper bound constraints here)

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for item in items:
        print(f"{item}: {x[item].x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

