
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_work_hours")

# Create variables
jean_hours = m.addVar(lb=0, name="jean_hours")  # Non-negative, can be fractional
paul_hours = m.addVar(lb=0, name="paul_hours") # Non-negative, can be fractional


# Set objective function
m.setObjective(9 * jean_hours + 9 * paul_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * jean_hours + 5 * paul_hours >= 29, "work_quality_min")
m.addConstr(7 * jean_hours + 5 * paul_hours <= 104, "work_quality_max") # corrected upper bound
m.addConstr(7 * jean_hours + 8 * paul_hours >= 40, "paperwork_min")
m.addConstr(7 * jean_hours + 8 * paul_hours <= 55, "paperwork_max") # corrected upper bound
m.addConstr(8 * jean_hours - 6 * paul_hours >= 0, "jean_paul_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f"Jean's hours: {jean_hours.x}")
    print(f"Paul's hours: {paul_hours.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f"Optimization ended with status {m.status}")

