
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="hours_worked_by_Jean")  # Hours worked by Jean
x1 = m.addVar(lb=0, name="hours_worked_by_Paul")  # Hours worked by Paul

# Objective function: Minimize 9*x0 + 9*x1
m.setObjective(9*x0 + 9*x1, GRB.MINIMIZE)

# Constraints
# Work quality constraint
m.addConstr(7*x0 + 5*x1 >= 29, name="work_quality_constraint")

# Paperwork competence constraint
m.addConstr(7*x0 + 8*x1 >= 40, name="paperwork_competence_constraint")

# Linear constraint
m.addConstr(8*x0 - 6*x1 >= 0, name="linear_constraint")

# Upper bound work quality constraint
m.addConstr(7*x0 + 5*x1 <= 104, name="upper_bound_work_quality")

# Upper bound paperwork competence constraint
m.addConstr(7*x0 + 8*x1 <= 55, name="upper_bound_paperwork_competence")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {x0.x}")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
