
import gurobi as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Define variables
hours_jean = m.addVar(name="hours_jean", lb=0)  # Lower bound is 0, assuming non-negative hours
hours_paul = m.addVar(name="hours_paul", lb=0)  # Lower bound is 0, assuming non-negative hours

# Objective function: Minimize 9 * (hours worked by Jean + hours worked by Paul)
m.setObjective(9 * hours_jean + 9 * hours_paul, gp.GRB.MINIMIZE)

# Constraints
# Total combined work quality rating >= 29
m.addConstraint(7 * hours_jean + 5 * hours_paul >= 29, name="work_quality_min")

# Total combined work quality rating <= 104
m.addConstraint(7 * hours_jean + 5 * hours_paul <= 104, name="work_quality_max")

# Total combined paperwork competence rating >= 40
m.addConstraint(7 * hours_jean + 8 * hours_paul >= 40, name="paperwork_min")

# Total combined paperwork competence rating <= 55
m.addConstraint(7 * hours_jean + 8 * hours_paul <= 55, name="paperwork_max")

# 8 * hours worked by Jean - 6 * hours worked by Paul >= 0
m.addConstraint(8 * hours_jean - 6 * hours_paul >= 0, name="jean_paul_constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Jean: {hours_jean.varValue}")
    print(f"Hours worked by Paul: {hours_paul.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
