
from gurobipy import Model, GRB, quicksum

# Create a new model
model = Model("optimization_problem")

# Create variables
fat = model.addVar(vtype=GRB.INTEGER, name="fat")  # Grams of fat (integer)
vitamin_b7 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b7")  # Milligrams of vitamin B7 (continuous)
magnesium = model.addVar(vtype=GRB.CONTINUOUS, name="magnesium")  # Milligrams of magnesium (continuous)


# Set objective function
obj = 2.27 * fat**2 + 5.44 * fat * vitamin_b7 + 4.8 * vitamin_b7**2 + 8.77 * vitamin_b7 * magnesium + 1.63 * magnesium**2 + 1.53 * magnesium
model.setObjective(obj, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * vitamin_b7 + 7 * magnesium >= 4, "immune_constraint1")
model.addConstr(1 * fat + 6 * vitamin_b7 >= 3, "immune_constraint2")
model.addConstr(1 * fat + 6 * vitamin_b7 + 7 * magnesium >= 3, "immune_constraint3")
model.addConstr(3 * fat - 5 * magnesium >= 0, "constraint4")
model.addConstr(-2 * vitamin_b7 + 9 * magnesium >= 0, "constraint5")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"Grams of fat: {fat.x}")
    print(f"Milligrams of vitamin B7: {vitamin_b7.x}")
    print(f"Milligrams of magnesium: {magnesium.x}")
    print(f"Objective value: {model.objVal}")

