
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name="grams_of_fat", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="milligrams_of_vitamin_B7")
x2 = m.addVar(name="milligrams_of_magnesium")

# Objective function
m.setObjective(2.27 * x0**2 + 5.44 * x0 * x1 + 4.8 * x1**2 + 8.77 * x1 * x2 + 1.63 * x2**2 + 1.53 * x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(x0 <= 26, name="immune_support_index_fat")
m.addConstr(6 * x1 <= 26, name="immune_support_index_vitamin_B7")
m.addConstr(7 * x2 <= 26, name="immune_support_index_magnesium")
m.addConstr(6 * x1 + 7 * x2 >= 4, name="combined_immune_support_index_vitamin_B7_magnesium")
m.addConstr(x0 + 6 * x1 >= 3, name="combined_immune_support_index_fat_vitamin_B7")
m.addConstr(x0 + 6 * x1 + 7 * x2 >= 3, name="combined_immune_support_index_fat_vitamin_B7_magnesium")
m.addConstr(3 * x0 - 5 * x2 >= 0, name="fat_magnesium_constraint")
m.addConstr(-2 * x1 + 9 * x2 >= 0, name="vitamin_B7_magnesium_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Grams of fat: {x0.varValue}")
    print(f"Milligrams of vitamin B7: {x1.varValue}")
    print(f"Milligrams of magnesium: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
