
from gurobipy import Model, GRB

# Create a new model
model = Model("resource_allocation")

# Create variables
milkshakes = model.addVar(vtype=GRB.CONTINUOUS, name="milkshakes")
cheeseburgers = model.addVar(vtype=GRB.INTEGER, name="cheeseburgers")
bananas = model.addVar(vtype=GRB.INTEGER, name="bananas")

# Set objective function
model.setObjective(8 * milkshakes + 4 * cheeseburgers + 4 * bananas, GRB.MAXIMIZE)

# Add constraints
model.addConstr(11 * milkshakes + 1 * cheeseburgers + 5 * bananas <= 45, "c0")  # Total fiber
model.addConstr(1 * milkshakes + 3 * cheeseburgers + 1 * bananas <= 84, "c1")  # Total cost
model.addConstr(1 * milkshakes + 3 * cheeseburgers + 1 * bananas >= 16, "c2")  # Minimum cost
model.addConstr(11 * milkshakes + 5 * bananas <= 31, "c3")  # Fiber from milkshakes and bananas
model.addConstr(11 * milkshakes + 1 * cheeseburgers <= 42, "c4")  # Fiber from milkshakes and cheeseburgers
model.addConstr(1 * cheeseburgers + 5 * bananas <= 27, "c5")  # Fiber from cheeseburgers and bananas
model.addConstr(11 * milkshakes + 1 * cheeseburgers + 5 * bananas <= 27, "c6")  # Fiber from all three
model.addConstr(1 * milkshakes + 3 * cheeseburgers <= 69, "c7")  # Cost of milkshakes and cheeseburgers
model.addConstr(1 * milkshakes + 3 * cheeseburgers + 1 * bananas <= 69, "c8")  # Cost of all three


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('milkshakes:', milkshakes.x)
    print('cheeseburgers:', cheeseburgers.x)
    print('bananas:', bananas.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

