
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milkshakes")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="cheeseburgers")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="bananas")

# Objective function
m.setObjective(8*x0 + 4*x1 + 4*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x0 + 3*x1 + x2 >= 16, "min_spend")
m.addConstr(11*x0 + 5*x2 <= 31, "fiber_milkshakes_bananas")
m.addConstr(11*x0 + x1 <= 42, "fiber_milkshakes_cheeseburgers")
m.addConstr(x1 + 5*x2 <= 27, "fiber_cheeseburgers_bananas")
m.addConstr(11*x0 + x1 + 5*x2 <= 27, "total_fiber")
m.addConstr(x0 + 3*x1 <= 69, "spend_milkshakes_cheeseburgers")
m.addConstr(x0 + 3*x1 + x2 <= 69, "total_spend")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milkshakes: {x0.x}")
    print(f"Cheeseburgers: {x1.x}")
    print(f"Bananas: {x2.x}")
else:
    print("No optimal solution found")
