
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    milkshakes = model.addVar(lb=0, name="milkshakes", vtype=gurobi.GRB.CONTINUOUS)
    cheeseburgers = model.addVar(lb=0, name="cheeseburgers", vtype=gurobi.GRB.INTEGER)
    bananas = model.addVar(lb=0, name="bananas", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8 * milkshakes + 4 * cheeseburgers + 4 * bananas, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1 * milkshakes + 3 * cheeseburgers + 1 * bananas >= 16, name="min_spend")
    model.addConstr(11 * milkshakes + 5 * bananas <= 31, name="fiber_milkshakes_bananas")
    model.addConstr(11 * milkshakes + 1 * cheeseburgers <= 42, name="fiber_milkshakes_cheeseburgers")
    model.addConstr(1 * cheeseburgers + 5 * bananas <= 27, name="fiber_cheeseburgers_bananas")
    model.addConstr(11 * milkshakes + 1 * cheeseburgers + 5 * bananas <= 27, name="total_fiber")
    model.addConstr(1 * milkshakes + 3 * cheeseburgers <= 69, name="cost_milkshakes_cheeseburgers")
    model.addConstr(1 * milkshakes + 3 * cheeseburgers + 1 * bananas <= 69, name="total_cost")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milkshakes: {milkshakes.varValue}")
        print(f"Cheeseburgers: {cheeseburgers.varValue}")
        print(f"Bananas: {bananas.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
