
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_Paul", lb=0)  # No upper bound for x0 and x1, but x2 is an integer
    x1 = model.addVar(name="hours_worked_by_Bill", lb=0)
    x2 = model.addVar(name="hours_worked_by_Jean", lb=0, type=gurobi.GRB.INTEGER)

    # Objective function: Minimize 6*x0 + 4*x1 + 3*x2
    model.setObjective(6*x0 + 4*x1 + 3*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    # Paperwork competence ratings
    model.addConstr(7*x0 + 3*x2 >= 31, name="paperwork_Paul_Jean")
    model.addConstr(7*x0 + 4*x1 >= 20, name="paperwork_Paul_Bill")
    model.addConstr(7*x0 + 4*x1 + 3*x2 >= 31, name="paperwork_all_min")
    model.addConstr(7*x0 + 4*x1 + 3*x2 <= 84, name="paperwork_all_max")

    # Work quality ratings
    model.addConstr(12*x0 + 12*x2 >= 26, name="work_quality_Paul_Jean")
    model.addConstr(12*x0 + 2*x1 >= 31, name="work_quality_Paul_Bill")
    model.addConstr(12*x0 + 2*x1 + 12*x2 >= 31, name="work_quality_all_min")
    model.addConstr(12*x0 + 2*x1 + 12*x2 <= 123, name="work_quality_all_max")

    # Additional constraints
    model.addConstr(6*x0 - x1 >= 0, name="additional_constraint_1")
    model.addConstr(4*x1 - 5*x2 >= 0, name="additional_constraint_2")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {x0.varValue}")
        print(f"Hours worked by Bill: {x1.varValue}")
        print(f"Hours worked by Jean: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
