
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
honeypots = m.addVar(vtype=GRB.INTEGER, name="honeypots")
sys_admins = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
soc_operators = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")

# Set objective function
m.setObjective(4.72 * honeypots + 8.14 * sys_admins + 1.24 * soc_operators, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.43 * honeypots + 3.96 * sys_admins >= 24, "data_integrity_constraint1")
m.addConstr(3.43 * honeypots + 3.96 * sys_admins + 5.3 * soc_operators >= 19, "data_integrity_constraint2")
m.addConstr(3.96 * sys_admins + 5.3 * soc_operators <= 110, "data_integrity_constraint3")
m.addConstr(3.43 * honeypots + 3.96 * sys_admins + 5.3 * soc_operators <= 113, "data_integrity_constraint4")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('honeypots:', honeypots.x)
    print('system_administrators:', sys_admins.x)
    print('SOC_operators:', soc_operators.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

