
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
honeypots = m.addVar(vtype=GRB.INTEGER, name="honeypots")
system_administrators = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
soc_operators = m.addVar(vtype=GRB.INTEGER, name="soc_operators")

# Define the objective function
m.setObjective(4.72 * honeypots + 8.14 * system_administrators + 1.24 * soc_operators, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.43 * honeypots + 3.96 * system_administrators >= 24, name="min_honeypot_sysadmin_impact")
m.addConstr(3.43 * honeypots + 3.96 * system_administrators + 5.3 * soc_operators >= 19, name="min_total_impact")
m.addConstr(3.96 * system_administrators + 5.3 * soc_operators <= 110, name="max_sysadmin_socop_impact")
m.addConstr(3.43 * honeypots + 3.96 * system_administrators + 5.3 * soc_operators <= 110, name="max_total_impact")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Honeypots: {honeypots.x}")
    print(f"System Administrators: {system_administrators.x}")
    print(f"SOC Operators: {soc_operators.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
