
import gurobipy as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
honeypots = model.addVar(name="honeypots", vtype=gp.GRB.INTEGER)
system_administrators = model.addVar(name="system_administrators", vtype=gp.GRB.INTEGER)
SOC_operators = model.addVar(name="SOC_operators", vtype=gp.GRB.INTEGER)

# Objective function
model.setObjective(4.72 * honeypots + 8.14 * system_administrators + 1.24 * SOC_operators, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3.43 * honeypots + 3.96 * system_administrators >= 24, name="constraint_1")
model.addConstr(3.43 * honeypots + 3.96 * system_administrators + 5.3 * SOC_operators >= 19, name="constraint_2")
model.addConstr(3.96 * system_administrators + 5.3 * SOC_operators <= 110, name="constraint_3")
model.addConstr(3.43 * honeypots + 3.96 * system_administrators + 5.3 * SOC_operators <= 110, name="constraint_4")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Honeypots: ", honeypots.varValue)
    print("System Administrators: ", system_administrators.varValue)
    print("SOC Operators: ", SOC_operators.varValue)
else:
    print("The model is infeasible")
