
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Work Cost")

# Create variables
laura_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura_Hours")
peggy_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Peggy_Hours")

# Set objective function
model.setObjective(2 * laura_hours + 7 * peggy_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * laura_hours + 12 * peggy_hours >= 73, "Work_Quality_Min")
model.addConstr(5 * laura_hours + 7 * peggy_hours >= 31, "Organization_Score_Min")
model.addConstr(-5 * laura_hours + 8 * peggy_hours >= 0, "Laura_Peggy_Hours_Relation")
model.addConstr(6 * laura_hours + 12 * peggy_hours <= 127, "Work_Quality_Max")
model.addConstr(5 * laura_hours + 7 * peggy_hours <= 99, "Organization_Score_Max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Laura's Hours: {laura_hours.x}")
    print(f"Peggy's Hours: {peggy_hours.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

