
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Decision variables
x0 = m.addVar(lb=0, name="hours_worked_by_Laura")
x1 = m.addVar(lb=0, name="hours_worked_by_Peggy")

# Objective function: minimize 2*x0 + 7*x1
m.setObjective(2*x0 + 7*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(6*x0 + 12*x1 >= 73, name="min_total_work_quality")
m.addConstr(5*x0 + 7*x1 >= 31, name="min_total_organization_score")
m.addConstr(-5*x0 + 8*x1 >= 0, name="additional_constraint")
m.addConstr(6*x0 + 12*x1 <= 127, name="max_total_work_quality")
m.addConstr(5*x0 + 7*x1 <= 99, name="max_total_organization_score")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Laura: {x0.x}")
    print(f"Hours worked by Peggy: {x1.x}")
else:
    print("No optimal solution found. Model status:", m.status)
