
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
laura_hours = m.addVar(name="laura_hours", lb=0)  # Assuming hours cannot be negative
peggy_hours = m.addVar(name="peggy_hours", lb=0)  # Assuming hours cannot be negative

# Objective function
m.setObjective(2 * laura_hours + 7 * peggy_hours, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(6 * laura_hours + 12 * peggy_hours >= 73, name="work_quality_min")
m.addConstr(5 * laura_hours + 7 * peggy_hours >= 31, name="organization_min")
m.addConstr(-5 * laura_hours + 8 * peggy_hours >= 0, name="combined_constraint")
m.addConstr(6 * laura_hours + 12 * peggy_hours <= 127, name="work_quality_max")
m.addConstr(5 * laura_hours + 7 * peggy_hours <= 99, name="organization_max")

# Laura's individual work quality and organization score constraints
# These are already implied by the problem statement but explicitly adding for clarity
m.addConstr(6 * laura_hours == 6, name="laura_work_quality")
m.addConstr(5 * laura_hours == 5, name="laura_organization")
# Peggy's individual work quality and organization score constraints
m.addConstr(12 * peggy_hours == 12, name="peggy_work_quality")
m.addConstr(7 * peggy_hours == 7, name="peggy_organization")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Laura's hours: {laura_hours.varValue}")
    print(f"Peggy's hours: {peggy_hours.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
