
from gurobipy import Model, GRB

# Create a new model
m = Model("Productivity Optimization")

# Create variables
paul_hours = m.addVar(vtype=GRB.INTEGER, name="paul_hours")
jean_hours = m.addVar(vtype=GRB.INTEGER, name="jean_hours")
ringo_hours = m.addVar(vtype=GRB.CONTINUOUS, name="ringo_hours")

# Set objective function
m.setObjective(7.29 * paul_hours + 8.85 * jean_hours + 1.49 * ringo_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * paul_hours + 12 * ringo_hours <= 43, "c1")
m.addConstr(9 * jean_hours + 12 * ringo_hours <= 37, "c2")
m.addConstr(7 * paul_hours + 9 * jean_hours + 12 * ringo_hours <= 93, "c3")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Paul Hours: %g' % paul_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
    print('Ringo Hours: %g' % ringo_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

