
from gurobipy import *

# Create a model
m = Model("Work Hours Optimization")

# Define variables
P = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")
J = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")
R = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")

# Objective function
m.setObjective(7.29*P + 8.85*J + 1.49*R, GRB.MAXIMIZE)

# Constraints
m.addConstr(7*P + 12*R <= 43, "Paul_and_Ringo_productivity")
m.addConstr(9*J + 12*R <= 37, "Jean_and_Ringo_productivity")
m.addConstr(7*P + 9*J + 12*R <= 93, "Total_productivity")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {P.x}")
    print(f"Hours worked by Jean: {J.x}")
    print(f"Hours worked by Ringo: {R.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
