
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
P = m.addVar(name="hours_worked_by_Paul", lowBound=0, vtype=gp.GRB.INTEGER)
J = m.addVar(name="hours_worked_by_Jean", lowBound=0, vtype=gp.GRB.INTEGER)
R = m.addVar(name="hours_worked_by_Ringo", lowBound=0)

# Objective function
m.setObjective(7.29 * P + 8.85 * J + 1.49 * R, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(7 * P + 12 * R <= 43, name="productivity_constraint_paul_ringo")
m.addConstr(9 * J + 12 * R <= 37, name="productivity_constraint_jean_ringo")
m.addConstr(7 * P + 9 * J + 12 * R <= 93, name="productivity_constraint_all")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Paul: {P.varValue}")
    print(f"Hours worked by Jean: {J.varValue}")
    print(f"Hours worked by Ringo: {R.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible or unbounded.")
