
import gurobi as gp

m = gp.Model("optimization_problem")

# Define variables
vars = ["deployed_decoys", "automatic_alerts", "security_onions", "pen_testers", "patches_per_day", "network_administrators", "honeypots"]
var_list = [m.addVar(name=var, vtype=gp.GRB.INTEGER) for var in vars]

# Objective function coefficients
obj_coeffs = [1, 5, 1, 9, 6, 2, 7]

# Define the objective function
m.setObjective(sum([obj_coeffs[i] * var_list[i] for i in range(len(vars))]), gp.GRB.MINIMIZE)

# Constraints
# Network Integrity Impact
cons = {
    'r0': {'description': 'network integrity impact', 'upper_bound': 767, 'x': [22, 26, 18, 3, 6, 5, 13]},
    'r1': {'description': 'data accessibility impact', 'upper_bound': 319, 'x': [21, 5, 12, 11, 3, 12, 28]}
}

for key, value in cons.items():
    m.addConstr(sum([value['x'][i] * var_list[i] for i in range(len(vars))]) <= value['upper_bound'])

# Additional constraints from the problem description
# Example
m.addConstr(6 * var_list[4] + 5 * var_list[5] >= 61)

try:
    m.optimize()
    if m.status == gp.GRB.OPTIMAL:
        print("Objective: ", m.objVal)
        for i, var in enumerate(vars):
            print(f"{var}: {var_list[i].varValue}")
    else:
        print("No optimal solution found")
except gp.GUROBI_ERROR as e:
    print("Gurobi Error: ", e)
