
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("resource_allocation")

# Create variables
ringo_hours = m.addVar(name="ringo_hours")
hank_hours = m.addVar(name="hank_hours")
peggy_hours = m.addVar(name="peggy_hours")
laura_hours = m.addVar(name="laura_hours")

# Set objective function
m.setObjective(2.41 * ringo_hours**2 + 5.49 * ringo_hours * hank_hours + 1.74 * ringo_hours * peggy_hours + 6.27 * ringo_hours * laura_hours + 9.86 * hank_hours**2 + 1.8 * hank_hours * laura_hours + 4.41 * peggy_hours**2 + 1.09 * peggy_hours * laura_hours + 3.96 * laura_hours**2 + 8.0 * ringo_hours + 9.94 * hank_hours + 9.96 * peggy_hours + 4.91 * laura_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.91 * peggy_hours**2 + 0.52 * laura_hours**2 >= 42)
m.addConstr(0.32 * hank_hours + 0.52 * laura_hours >= 64)
m.addConstr(0.71 * ringo_hours + 0.32 * hank_hours >= 67)
m.addConstr(0.71 * ringo_hours + 0.32 * hank_hours + 0.91 * peggy_hours + 0.52 * laura_hours >= 67)
m.addConstr(0.82 * hank_hours + 0.66 * peggy_hours >= 69)
m.addConstr(0.04 * ringo_hours**2 + 0.66 * peggy_hours**2 >= 32)
m.addConstr(0.66 * peggy_hours + 0.19 * laura_hours >= 26)
m.addConstr(0.04 * ringo_hours + 0.19 * laura_hours >= 40)
m.addConstr(0.04 * ringo_hours + 0.82 * hank_hours + 0.66 * peggy_hours + 0.19 * laura_hours >= 40)
m.addConstr(ringo_hours - 6 * peggy_hours >= 0)
m.addConstr(6 * ringo_hours - 10 * laura_hours >= 0)
m.addConstr(9 * hank_hours**2 - 3 * peggy_hours**2 + 10 * laura_hours**2 >= 0)
m.addConstr(0.32 * hank_hours + 0.91 * peggy_hours <= 258)
m.addConstr(0.71 * ringo_hours + 0.52 * laura_hours <= 321)
m.addConstr(0.32 * hank_hours**2 + 0.52 * laura_hours**2 <= 243)
m.addConstr(0.32 * hank_hours + 0.91 * peggy_hours + 0.52 * laura_hours <= 154)
m.addConstr(0.04 * ringo_hours**2 + 0.19 * laura_hours**2 <= 163)
m.addConstr(0.66 * peggy_hours**2 + 0.19 * laura_hours**2 <= 186)
m.addConstr(0.82 * hank_hours + 0.19 * laura_hours <= 143)
m.addConstr(0.04 * ringo_hours**2 + 0.82 * hank_hours**2 + 0.66 * peggy_hours**2 <= 245)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Ringo Hours: %g' % ringo_hours.x)
    print('Hank Hours: %g' % hank_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
    print('Laura Hours: %g' % laura_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
