
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
R = m.addVar(lb=0, name="Ringo")
H = m.addVar(lb=0, name="Hank")
P = m.addVar(lb=0, name="Peggy")
L = m.addVar(lb=0, name="Laura")

# Define the objective function
m.setObjective(2.41*R**2 + 5.49*R*H + 1.74*R*P + 6.27*R*L + 
               9.86*H**2 + 1.8*H*L + 4.41*P**2 + 1.09*P*L + 
               3.96*L**2 + 8.0*R + 9.94*H + 9.96*P + 4.91*L, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.71*R <= 391)
m.addConstr(0.04*R <= 305)
m.addConstr(0.32*H <= 391)
m.addConstr(0.82*H <= 305)
m.addConstr(0.91*P <= 391)
m.addConstr(0.66*P <= 305)
m.addConstr(0.52*L <= 391)
m.addConstr(0.19*L <= 305)
m.addConstr(0.91*P**2 + 0.52*L**2 >= 42)
m.addConstr(0.32*H + 0.52*L >= 64)
m.addConstr(0.71*R + 0.32*H >= 67)
m.addConstr(0.71*R + 0.32*H + 0.91*P + 0.52*L >= 67)
m.addConstr(0.82*H + 0.66*P >= 69)
m.addConstr(0.04*R**2 + 0.66*P**2 >= 32)
m.addConstr(0.66*P + 0.19*L >= 26)
m.addConstr(0.04*R + 0.19*L >= 40)
m.addConstr(0.04*R + 0.82*H + 0.66*P + 0.19*L >= 40)
m.addConstr(R - 6*P >= 0)
m.addConstr(6*R - 10*L >= 0)
m.addConstr(9*H**2 - 3*P**2 + 10*L**2 >= 0)
m.addConstr(0.32*H + 0.91*P <= 258)
m.addConstr(0.71*R + 0.52*L <= 321)
m.addConstr(0.32*H**2 + 0.52*L**2 <= 243)
m.addConstr(0.32*H + 0.91*P + 0.52*L <= 154)
m.addConstr(0.04*R**2 + 0.19*L**2 <= 163)
m.addConstr(0.66*P**2 + 0.19*L**2 <= 186)
m.addConstr(0.82*H + 0.19*L <= 143)
m.addConstr(0.04*R**2 + 0.82*H**2 + 0.66*P**2 <= 245)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ringo: ", R.varValue)
    print("Hank: ", H.varValue)
    print("Peggy: ", P.varValue)
    print("Laura: ", L.varValue)
else:
    print("The model is infeasible")
