
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
cereal = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cereal")
oranges = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oranges")
pasta = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pasta")

# Set objective function
m.setObjective(8 * cereal + 3 * oranges + 2 * pasta, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * cereal + 5 * pasta >= 21, "carb_cereal_pasta_min")
m.addConstr(6 * cereal + 3 * oranges + 5 * pasta >= 34, "carb_total_min")
m.addConstr(4 * cereal + 1 * pasta >= 37, "calcium_cereal_pasta_min")
m.addConstr(4 * cereal + 4 * oranges >= 23, "calcium_cereal_oranges_min")
m.addConstr(4 * oranges + 1 * pasta >= 34, "calcium_oranges_pasta_min")
m.addConstr(4 * cereal + 4 * oranges + 1 * pasta >= 35, "calcium_total_min")
m.addConstr(6 * cereal + 5 * pasta <= 48, "carb_cereal_pasta_max")
m.addConstr(6 * cereal + 3 * oranges + 5 * pasta <= 73, "carb_total_max")


# Resource Constraints (given in the prompt)
m.addConstr(6 * cereal + 3 * oranges + 5 * pasta <= 108, "carb_limit") #r0
m.addConstr(4 * cereal + 4 * oranges + 1 * pasta <= 132, "calcium_limit") #r1


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cereal:', cereal.x)
    print('oranges:', oranges.x)
    print('pasta:', pasta.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

