
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Decision Variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_cereal")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="oranges")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_pasta")

# Objective Function
m.setObjective(8*x0 + 3*x1 + 2*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(6*x0 + 5*x2 >= 21, "carb_cereal_pasta")
m.addConstr(6*x0 + 3*x1 + 5*x2 >= 34, "total_carb")
m.addConstr(4*x0 + x2 >= 37, "calcium_cereal_pasta")
m.addConstr(4*x0 + 4*x1 >= 23, "calcium_cereal_orange")
m.addConstr(4*x1 + x2 >= 34, "calcium_orange_pasta")
m.addConstr(4*x0 + 4*x1 + x2 >= 35, "total_calcium")
m.addConstr(6*x0 + 5*x2 <= 48, "upper_carb_cereal_pasta")
m.addConstr(6*x0 + 3*x1 + 5*x2 <= 73, "upper_total_carb")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"bowls_of_cereal: {x0.x}")
    print(f"oranges: {x1.x}")
    print(f"bowls_of_pasta: {x2.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found.")
