
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    bowls_of_cereal = model.addVar(lb=0, name="bowls_of_cereal", vtype=gurobi.GRB.CONTINUOUS)
    oranges = model.addVar(lb=0, name="oranges", vtype=gurobi.GRB.CONTINUOUS)
    bowls_of_pasta = model.addVar(lb=0, name="bowls_of_pasta", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(8 * bowls_of_cereal + 3 * oranges + 2 * bowls_of_pasta, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6 * bowls_of_cereal + 5 * bowls_of_pasta >= 21, name="carbohydrates_cereal_pasta")
    model.addConstr(6 * bowls_of_cereal + 3 * oranges + 5 * bowls_of_pasta >= 34, name="total_carbohydrates")
    model.addConstr(4 * bowls_of_cereal + bowls_of_pasta >= 37, name="calcium_cereal_pasta")
    model.addConstr(4 * bowls_of_cereal + 4 * oranges >= 23, name="calcium_cereal_oranges")
    model.addConstr(4 * oranges + bowls_of_pasta >= 34, name="calcium_oranges_pasta")
    model.addConstr(4 * bowls_of_cereal + 4 * oranges + bowls_of_pasta >= 35, name="total_calcium")
    model.addConstr(6 * bowls_of_cereal + 5 * bowls_of_pasta <= 48, name="carbohydrates_cereal_pasta_ub")
    model.addConstr(6 * bowls_of_cereal + 3 * oranges + 5 * bowls_of_pasta <= 73, name="total_carbohydrates_ub")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Bowls of cereal: {bowls_of_cereal.varValue}")
        print(f"Oranges: {oranges.varValue}")
        print(f"Bowls of pasta: {bowls_of_pasta.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize()
