
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
eggs = m.addVar(vtype=GRB.INTEGER, name="eggs")
bacon = m.addVar(vtype=GRB.CONTINUOUS, name="bacon")
sandwiches = m.addVar(vtype=GRB.INTEGER, name="sandwiches")
chicken = m.addVar(vtype=GRB.INTEGER, name="chicken")

# Set objective function
m.setObjective(6*eggs + 3*bacon + 6*sandwiches + 9*chicken, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*eggs + 17*bacon >= 31, "c1")
m.addConstr(8*eggs + 14*chicken >= 36, "c2")
m.addConstr(17*bacon + 8*sandwiches >= 18, "c3")
m.addConstr(17*bacon + 8*sandwiches + 14*chicken >= 35, "c4")
m.addConstr(8*eggs + 8*sandwiches + 14*chicken >= 35, "c5")
m.addConstr(8*eggs + 17*bacon + 14*chicken >= 35, "c6")
m.addConstr(17*bacon + 8*sandwiches + 14*chicken >= 38, "c7")
m.addConstr(8*eggs + 8*sandwiches + 14*chicken >= 38, "c8")
m.addConstr(8*eggs + 17*bacon + 14*chicken >= 38, "c9")
m.addConstr(17*bacon + 8*sandwiches + 14*chicken >= 36, "c10")
m.addConstr(8*eggs + 8*sandwiches + 14*chicken >= 36, "c11")
m.addConstr(8*eggs + 17*bacon + 14*chicken >= 36, "c12")
m.addConstr(8*eggs + 17*bacon + 8*sandwiches + 14*chicken >= 36, "c13")

m.addConstr(3*bacon + 6*chicken >= 15, "c14")
m.addConstr(7*eggs + 10*sandwiches >= 45, "c15")
m.addConstr(10*sandwiches + 6*chicken >= 32, "c16")
m.addConstr(7*eggs + 3*bacon + 6*chicken >= 22, "c17")
m.addConstr(7*eggs + 3*bacon + 10*sandwiches + 6*chicken >= 22, "c18")

m.addConstr(13*sandwiches + 8*chicken >= 21, "c19")
m.addConstr(8*eggs + 6*bacon >= 15, "c20")
m.addConstr(8*eggs + 8*chicken >= 18, "c21")
m.addConstr(6*bacon + 13*sandwiches >= 11, "c22")
m.addConstr(8*eggs + 6*bacon + 13*sandwiches + 8*chicken >= 11, "c23")

m.addConstr(9*bacon - sandwiches >= 0, "c24")
m.addConstr(8*sandwiches + 14*chicken <= 60, "c25")
m.addConstr(10*sandwiches + 6*chicken <= 151, "c26")


# Resource Constraints
m.addConstr(8*eggs + 17*bacon + 8*sandwiches + 14*chicken <= 167, "carbohydrate_limit")
m.addConstr(7*eggs + 3*bacon + 10*sandwiches + 6*chicken <= 183, "iron_limit")
m.addConstr(8*eggs + 6*bacon + 13*sandwiches + 8*chicken <= 118, "umami_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

