
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
eggs = m.addVar(name="eggs", vtype=gurobi.GRB.INTEGER)
strips_of_bacon = m.addVar(name="strips_of_bacon", vtype=gurobi.GRB.CONTINUOUS)
peanutbutter_sandwiches = m.addVar(name="peanutbutter_sandwiches", vtype=gurobi.GRB.INTEGER)
chicken_breasts = m.addVar(name="chicken_breasts", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(6 * eggs + 3 * strips_of_bacon + 6 * peanutbutter_sandwiches + 9 * chicken_breasts, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * eggs + 17 * strips_of_bacon + 8 * peanutbutter_sandwiches + 14 * chicken_breasts <= 167)
m.addConstr(7 * eggs + 3 * strips_of_bacon + 10 * peanutbutter_sandwiches + 6 * chicken_breasts <= 183)
m.addConstr(8 * eggs + 6 * strips_of_bacon + 13 * peanutbutter_sandwiches + 8 * chicken_breasts <= 118)

m.addConstr(8 * eggs + 17 * strips_of_bacon >= 31)
m.addConstr(8 * eggs + 14 * chicken_breasts >= 36)
m.addConstr(17 * strips_of_bacon + 8 * peanutbutter_sandwiches >= 18)
m.addConstr(17 * strips_of_bacon + 8 * peanutbutter_sandwiches + 14 * chicken_breasts >= 35)
m.addConstr(8 * eggs + 8 * peanutbutter_sandwiches + 14 * chicken_breasts >= 35)
m.addConstr(8 * eggs + 17 * strips_of_bacon + 14 * chicken_breasts >= 35)
m.addConstr(17 * strips_of_bacon + 8 * peanutbutter_sandwiches + 14 * chicken_breasts >= 38)
m.addConstr(8 * eggs + 8 * peanutbutter_sandwiches + 14 * chicken_breasts >= 38)
m.addConstr(8 * eggs + 17 * strips_of_bacon + 14 * chicken_breasts >= 38)
m.addConstr(17 * strips_of_bacon + 8 * peanutbutter_sandwiches + 14 * chicken_breasts >= 36)
m.addConstr(8 * eggs + 8 * peanutbutter_sandwiches + 14 * chicken_breasts >= 36)
m.addConstr(8 * eggs + 17 * strips_of_bacon + 14 * chicken_breasts >= 36)
m.addConstr(8 * eggs + 17 * strips_of_bacon + 8 * peanutbutter_sandwiches + 14 * chicken_breasts >= 36)

m.addConstr(3 * strips_of_bacon + 6 * chicken_breasts >= 15)
m.addConstr(7 * eggs + 10 * peanutbutter_sandwiches >= 45)
m.addConstr(10 * peanutbutter_sandwiches + 6 * chicken_breasts >= 32)
m.addConstr(7 * eggs + 3 * strips_of_bacon + 6 * chicken_breasts >= 22)
m.addConstr(7 * eggs + 3 * strips_of_bacon + 10 * peanutbutter_sandwiches + 6 * chicken_breasts >= 22)

m.addConstr(13 * peanutbutter_sandwiches + 8 * chicken_breasts >= 21)
m.addConstr(8 * eggs + 6 * strips_of_bacon >= 15)
m.addConstr(8 * eggs + 8 * chicken_breasts >= 18)
m.addConstr(6 * strips_of_bacon + 13 * peanutbutter_sandwiches >= 11)
m.addConstr(8 * eggs + 6 * strips_of_bacon + 13 * peanutbutter_sandwiches + 8 * chicken_breasts >= 11)

m.addConstr(9 * strips_of_bacon - peanutbutter_sandwiches >= 0)
m.addConstr(8 * peanutbutter_sandwiches + 14 * chicken_breasts <= 60)
m.addConstr(10 * peanutbutter_sandwiches + 6 * chicken_breasts <= 151)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Eggs: ", eggs.varValue)
    print("Strips of bacon: ", strips_of_bacon.varValue)
    print("Peanutbutter sandwiches: ", peanutbutter_sandwiches.varValue)
    print("Chicken breasts: ", chicken_breasts.varValue)
else:
    print("The model is infeasible")
