
import gurobi as gp

model = gp.Model()

x0 = model.addVar(name="slices of pizza", lb=0, ub=None)
x1 = model.addVar(name="knishes", lb=0, ub=None)
x2 = model.addVar(name="bagged salads", lb=0, ub=None)
x3 = model.addVar(name="corn cobs", lb=0, ub=None)
x4 = model.addVar(name="steaks", lb=0, ub=None)
x5 = model.addVar(name="tomatoes", lb=0, ub=None)
x6 = model.addVar(name="hot dogs", lb=0, ub=None)

model.setObjective(2.85*x0 + 8.81*x1 + 5.07*x2 + 8.27*x3 + 1.99*x4 + 9.22*x5 + 4.38*x6, gp.GRB.MAXIMIZE)

model.addConstr(x1 + x5 >= 20)
model.addConstr(x1 + x2 >= 24)
model.addConstr(x3 + x5 >= 59)
model.addConstr(x2 + x3 >= 47)
model.addConstr(x4 + x6 >= 50)
model.addConstr(x2 + x4 + x6 >= 42)
model.addConstr(x0 + x4 + x5 >= 42)
model.addConstr(x1 + x5 + x6 >= 42)
model.addConstr(x1 + x4 + x6 >= 42)
model.addConstr(x1 + x2 + x5 >= 42)
model.addConstr(x0 + x2 + x6 >= 42)
model.addConstr(x3 + x4 + x5 >= 42)
model.addConstr(x0 + x1 + x2 >= 42)
model.addConstr(x1 + x3 + x5 >= 42)
model.addConstr(x2 + x3 + x6 >= 42)
model.addConstr(x2 + x3 + x5 >= 42)
model.addConstr(x2 + x4 + x5 >= 42)
model.addConstr(x2 + x4 + x6 >= 53)
model.addConstr(x0 + x4 + x5 >= 53)
model.addConstr(x1 + x5 + x6 >= 53)

model.addConstr(5*x2 + 7*x6 >= 28)
model.addConstr(11*x0 + 13*x5 >= 23)
model.addConstr(11*x0 + 8*x4 >= 32)
model.addConstr(4*x3 + 7*x6 >= 55)
model.addConstr(8*x4 + 13*x5 >= 27)
model.addConstr(5*x2 + 8*x4 >= 24)
model.addConstr(5*x2 + 13*x5 >= 46)
model.addConstr(4*x3 + 8*x4 >= 43)
model.addConstr(4*x1 + 5*x2 >= 43)
model.addConstr(11*x0 + 4*x1 >= 46)
model.addConstr(4*x2 + 4*x3 >= 54)

model.addConstr(12*x0 + 8*x3 <= 408)
model.addConstr(8*x3 + 6*x5 <= 345)
model.addConstr(6*x2 + 8*x6 <= 88)
model.addConstr(6*x2 + 4*x4 + 8*x6 <= 114)
model.addConstr(12*x0 + 6*x5 + 8*x6 <= 327)

model.optimize()

if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("slices of pizza: ", x0.varValue)
    print("knishes: ", x1.varValue)
    print("bagged salads: ", x2.varValue)
    print("corn cobs: ", x3.varValue)
    print("steaks: ", x4.varValue)
    print("tomatoes: ", x5.varValue)
    print("hot dogs: ", x6.varValue)
else:
    print("No solution found")
