
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
hank = m.addVar(lb=0, name="hours worked by Hank")
jean = m.addVar(lb=0, name="hours worked by Jean")
bill = m.addVar(lb=0, name="hours worked by Bill")
laura = m.addVar(lb=0, name="hours worked by Laura")
peggy = m.addVar(lb=0, name="hours worked by Peggy")
ringo = m.addVar(lb=0, name="hours worked by Ringo")
mary = m.addVar(lb=0, name="hours worked by Mary")
bobby = m.addVar(lb=0, name="hours worked by Bobby")

# Set objective function
m.setObjective(9 * hank + 6 * jean + 6 * bill + 4 * laura + 9 * peggy + 7 * ringo + 9 * mary + 1 * bobby, gp.GRB.MAXIMIZE)

# Add productivity rating constraints
productivity = {'Hank': 12, 'Jean': 4, 'Bill': 7, 'Laura': 2, 'Peggy': 12, 'Ringo': 3, 'Mary': 6, 'Bobby': 1}
organization = {'Hank': 1, 'Jean': 10, 'Bill': 4, 'Laura': 5, 'Peggy': 9, 'Ringo': 10, 'Mary': 12, 'Bobby': 8}

m.addConstr(7 * bill + 2 * laura >= 7)
m.addConstr(7 * bill + 3 * ringo >= 4)
m.addConstr(2 * laura + 3 * ringo >= 11)
m.addConstr(12 * hank + 4 * jean >= 11)
m.addConstr(4 * jean + 1 * bobby >= 5)
m.addConstr(3 * ringo + 1 * bobby >= 5)
m.addConstr(7 * bill + 1 * bobby >= 14)
m.addConstr(12 * hank + 12 * peggy >= 13)
m.addConstr(12 * hank + 3 * ringo >= 14)
m.addConstr(3 * ringo + 6 * mary >= 8)
m.addConstr(12 * peggy + 3 * ringo >= 14)
m.addConstr(12 * hank + 6 * mary >= 5)
m.addConstr(2 * laura + 6 * mary >= 9)
m.addConstr(12 * hank + 7 * bill >= 9)
m.addConstr(12 * peggy + 1 * bobby >= 7)
m.addConstr(4 * jean + 7 * bill >= 4)
m.addConstr(2 * laura + 12 * peggy + 3 * ringo >= 12)
m.addConstr(2 * laura + 6 * mary + 1 * bobby >= 12)
m.addConstr(2 * laura + 12 * peggy + 3 * ringo >= 11)
m.addConstr(2 * laura + 6 * mary + 1 * bobby >= 11)

m.addConstr(12 * hank + 1 * bobby <= 101)
m.addConstr(12 * hank + 7 * bill <= 43)
m.addConstr(7 * bill + 6 * mary <= 82)
m.addConstr(2 * laura + 3 * ringo <= 98)
m.addConstr(4 * jean + 7 * bill <= 81)
m.addConstr(3 * ringo + 6 * mary <= 29)
m.addConstr(4 * jean + 2 * laura <= 84)
m.addConstr(12 * hank + 12 * peggy <= 43)
m.addConstr(2 * laura + 1 * bobby <= 46)
m.addConstr(7 * bill + 3 * ringo <= 21)
m.addConstr(12 * peggy + 6 * mary <= 81)
m.addConstr(4 * jean + 1 * bobby <= 27)
m.addConstr(3 * ringo + 1 * bobby <= 108)
m.addConstr(12 * hank + 4 * jean <= 80)
m.addConstr(6 * mary + 1 * bobby <= 105)
m.addConstr(2 * laura + 12 * peggy <= 109)
m.addConstr(7 * bill + 1 * bobby <= 33)
m.addConstr(7 * bill + 2 * laura <= 113)
m.addConstr(12 * hank + 6 * mary <= 68)
m.addConstr(4 * jean + 12 * peggy <= 53)
m.addConstr(7 * bill + 12 * peggy <= 108)


# Resource constraints
m.addConstr(sum([productivity[person] * eval(person.lower()) for person in productivity]) <= 114, "r0")
m.addConstr(sum([organization[person] * eval(person.lower()) for person in organization]) <= 147, "r1")


# Additional constraints
m.addConstr(-7 * jean + 4 * ringo >= 0)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

